var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { jsx as _jsx } from "react/jsx-runtime";
import { Box, RadioButton } from '@rocket.chat/fuselage';
import { useSafely } from '@rocket.chat/fuselage-hooks';
import { GenericMenu } from '@rocket.chat/ui-client';
import { useAvailableDevices, useSelectedDevices } from '@rocket.chat/ui-contexts';
import { forwardRef, useCallback, useState } from 'react';
import { useTranslation } from 'react-i18next';
import { ActionButton } from '.';
import { useDevicePermissionPrompt2, stopTracks } from '../../hooks/useDevicePermissionPrompt';
import { useMediaCallContext } from '../MediaCallContext';
// GenericMenu for some reason passes `small: true` when the button is disabled (??).
// so this is just a wrapper to stop that from happening.
const DevicePickerButton = forwardRef(function DevicePickerButton(_a, ref) {
    var { secondary = false, small: _small } = _a, props = __rest(_a, ["secondary", "small"]);
    return _jsx(ActionButton, Object.assign({ secondary: secondary }, props, { label: 'customize', icon: 'customize', ref: ref }));
});
const getDefaultDeviceItem = (label, type) => ({
    content: (_jsx(Box, { is: 'span', title: label, fontSize: 14, children: label })),
    addon: _jsx(RadioButton, { onChange: () => undefined, checked: true, disabled: true }),
    id: `default-${type}`,
});
// eslint-disable-next-line react/no-multi-comp
const DevicePicker = ({ secondary = false }) => {
    var _a, _b;
    const { t } = useTranslation();
    const { onDeviceChange } = useMediaCallContext();
    const availableDevices = useAvailableDevices();
    const selectedAudioDevices = useSelectedDevices();
    const availableInputDevice = ((_a = availableDevices === null || availableDevices === void 0 ? void 0 : availableDevices.audioInput) === null || _a === void 0 ? void 0 : _a.map((device) => {
        var _a;
        if (!device.id || !device.label) {
            return getDefaultDeviceItem(t('Default'), 'input');
        }
        return {
            id: `${device.id}-input`,
            content: (_jsx(Box, { is: 'span', title: device.label, fontSize: 14, children: device.label })),
            addon: _jsx(RadioButton, { checked: device.id === ((_a = selectedAudioDevices === null || selectedAudioDevices === void 0 ? void 0 : selectedAudioDevices.audioInput) === null || _a === void 0 ? void 0 : _a.id) }),
        };
    })) || [];
    const availableOutputDevice = ((_b = availableDevices === null || availableDevices === void 0 ? void 0 : availableDevices.audioOutput) === null || _b === void 0 ? void 0 : _b.map((device) => {
        var _a;
        if (!device.id || !device.label) {
            return getDefaultDeviceItem(t('Default'), 'output');
        }
        return {
            id: `${device.id}-output`,
            content: (_jsx(Box, { is: 'span', title: device.label, fontSize: 14, children: device.label })),
            addon: _jsx(RadioButton, { checked: device.id === ((_a = selectedAudioDevices === null || selectedAudioDevices === void 0 ? void 0 : selectedAudioDevices.audioOutput) === null || _a === void 0 ? void 0 : _a.id) }),
            onClick(e) {
                e === null || e === void 0 ? void 0 : e.preventDefault();
                e === null || e === void 0 ? void 0 : e.stopPropagation();
            },
        };
    })) || [];
    const micSection = {
        title: t('Microphone'),
        items: availableInputDevice,
    };
    const speakerSection = {
        title: t('Speaker'),
        items: availableOutputDevice,
    };
    const disabled = availableOutputDevice.length === 0 && availableInputDevice.length === 0;
    const [isOpen, setIsOpen] = useSafely(useState(false));
    const requestPermission = useDevicePermissionPrompt2();
    const onOpenChange = useCallback((isOpen) => {
        if (!isOpen) {
            setIsOpen(false);
            return;
        }
        void requestPermission({
            actionType: 'device-change',
        }).then((stream) => {
            stopTracks(stream);
            setIsOpen(true);
        });
    }, [requestPermission, setIsOpen]);
    return (_jsx(GenericMenu, { title: disabled ? t('Device_settings_not_supported_by_browser') : t('Device_settings_lowercase'), sections: [micSection, speakerSection], disabled: disabled, placement: 'top-end', selectionMode: 'multiple', isOpen: isOpen, onOpenChange: onOpenChange, onAction: (deviceId) => {
            var _a, _b;
            if (typeof deviceId !== 'string') {
                return;
            }
            if (deviceId.includes('-input')) {
                const id = deviceId.replace('-input', '');
                const device = (_a = availableDevices === null || availableDevices === void 0 ? void 0 : availableDevices.audioInput) === null || _a === void 0 ? void 0 : _a.find((device) => device.id === id);
                if (device) {
                    onDeviceChange(device);
                }
                return;
            }
            if (deviceId.includes('-output')) {
                const id = deviceId.replace('-output', '');
                const device = (_b = availableDevices === null || availableDevices === void 0 ? void 0 : availableDevices.audioOutput) === null || _b === void 0 ? void 0 : _b.find((device) => device.id === id);
                if (device) {
                    onDeviceChange(device);
                }
                return;
            }
            console.warn('Device Picker - Failed to select device: Invalid deviceId', deviceId);
        }, button: _jsx(DevicePickerButton, { secondary: secondary, tiny: !secondary }) }));
};
export default DevicePicker;
//# sourceMappingURL=DevicePicker.js.map