import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { css } from '@rocket.chat/css-in-js';
import { Box, Button } from '@rocket.chat/fuselage';
import { mergeProps, useLongPress, usePress } from 'react-aria';
import { useTranslation } from 'react-i18next';
const dialPadButtonClass = css `
	> .rcx-button--content {
		display: flex;
		flex-direction: column;
	}
`;
const Key = ({ primaryKey, alternativeKey, longPressKey, onLongKeyPress, onKeyPress, large }) => {
    const { t } = useTranslation();
    const { longPressProps } = useLongPress({
        accessibilityDescription: `${t(`Long_press_to_do_x`, { action: longPressKey })}`,
        onLongPress: () => longPressKey && onLongKeyPress(longPressKey),
    });
    const { pressProps } = usePress({
        onPress: () => onKeyPress(primaryKey),
    });
    const buttonProps = longPressKey ? mergeProps(pressProps, longPressProps) : pressProps;
    return (_jsxs(Button, Object.assign({ minWidth: 52, w: 52, h: 40, p: 0, m: 4 }, buttonProps, { className: dialPadButtonClass, borderRadius: 8, children: [_jsx(Box, { is: 'span', fontScale: large ? 'h1' : 'p1', fontWeight: large ? 300 : 400, mb: -4, children: primaryKey }), _jsx(Box, { is: 'span', fontScale: 'c1', color: 'hint', "aria-hidden": true, minHeight: 16, letterSpacing: '0.15em', children: alternativeKey })] })));
};
export default Key;
//# sourceMappingURL=Key.js.map