import { jsx as _jsx } from "react/jsx-runtime";
import { Box } from '@rocket.chat/fuselage';
import { FocusScope } from 'react-aria';
import Key from './Key';
const DIGITS = [
    ['1', ''],
    ['2', 'ABC'],
    ['3', 'DEF'],
    ['4', 'GHI'],
    ['5', 'JKL'],
    ['6', 'MNO'],
    ['7', 'PQRS'],
    ['8', 'TUV'],
    ['9', 'WXYZ'],
    ['*', ''],
    ['0', '+', '+'],
    ['#', ''],
];
const Keypad = ({ onKeyPress }) => (_jsx(FocusScope, { autoFocus: true, children: _jsx(Box, { display: 'flex', justifyContent: 'center', flexWrap: 'wrap', maxWidth: 196, children: DIGITS.map(([primaryDigit, alternativeDigit, longPressDigit]) => (_jsx(Key, { large: primaryDigit === '*', primaryKey: primaryDigit, alternativeKey: alternativeDigit, longPressKey: longPressDigit, onLongKeyPress: onKeyPress, onKeyPress: onKeyPress }, primaryDigit))) }) }));
export default Keypad;
//# sourceMappingURL=Keypad.js.map