var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { AutoComplete, Option, Avatar, Field, FieldRow, FieldDescription, FieldError, StatusBullet, Box } from '@rocket.chat/fuselage';
import { useId } from 'react';
import { useTranslation } from 'react-i18next';
import { isFirstPeerAutocompleteOption } from '../MediaCallContext';
const PeerAutocomplete = ({ options, filter, value, onChangeValue, onChangeFilter, error }) => {
    const { t } = useTranslation();
    const fieldDescriptionId = useId();
    const fieldErrorId = useId();
    return (_jsxs(Field, { mb: -2, children: [_jsx(FieldRow, { children: _jsx(AutoComplete, { "aria-labelledby": fieldDescriptionId, "aria-describedby": error ? fieldErrorId : undefined, "aria-invalid": !!error, error: !!error, setFilter: onChangeFilter, filter: filter, onChange: onChangeValue, options: options, value: value, renderItem: (_a) => {
                        var { value, label } = _a, props = __rest(_a, ["value", "label"]);
                        if (isFirstPeerAutocompleteOption(value)) {
                            return _jsx(Option, Object.assign({ label: label, icon: 'phone-out' }, props), value);
                        }
                        const thisOption = options.find((option) => option.value === value);
                        return (_jsx(Option, Object.assign({ label: _jsxs(Box, { display: 'flex', flexDirection: 'row', alignItems: 'center', children: [_jsx(StatusBullet, { status: thisOption === null || thisOption === void 0 ? void 0 : thisOption.status }), _jsx(Box, { mis: 4, children: label })] }), avatar: _jsx(Avatar, { size: 'x20', url: (thisOption === null || thisOption === void 0 ? void 0 : thisOption.avatarUrl) || '' }) }, props), value));
                    }, renderSelected: () => null }) }), error && _jsx(FieldError, { id: fieldErrorId, children: error }), _jsx(FieldDescription, { id: fieldDescriptionId, children: t('Enter_username_or_number') })] }));
};
export default PeerAutocomplete;
//# sourceMappingURL=PeerAutocomplete.js.map