import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Avatar, Box, Icon, StatusBullet } from '@rocket.chat/fuselage';
const getRemoteStatusText = (slots) => {
    if (!(slots === null || slots === void 0 ? void 0 : slots.length)) {
        return undefined;
    }
    return slots.map((slot) => slot.text).join(', ');
};
const InternalUser = ({ displayName, avatarUrl, callerId, status, slots, remoteMuted }) => {
    const remoteStatusText = getRemoteStatusText(slots);
    return (_jsxs(Box, { display: 'flex', flexDirection: 'row', id: 'rcx-media-call-widget-caller-info', children: [_jsx(Box, { mie: 8, children: avatarUrl ? _jsx(Avatar, { url: avatarUrl, size: 'x20' }) : _jsx(Icon, { name: 'user', size: 'x20' }) }), _jsxs(Box, { display: 'flex', flexDirection: 'column', flexGrow: 1, children: [_jsxs(Box, { display: 'flex', flexDirection: 'row', alignItems: 'center', fontScale: 'p2b', color: 'default', justifyContent: 'space-between', children: [_jsxs(Box, { is: 'span', display: 'flex', flexDirection: 'row', alignItems: 'center', children: [status && _jsx(StatusBullet, { status: status, size: 'small' }), _jsx(Box, { mis: 4, children: displayName })] }), remoteMuted && _jsx(Icon, { name: 'mic-off', size: 'x16', color: 'danger' })] }), callerId && (_jsxs(Box, { fontScale: 'c1', color: 'secondary-info', children: [callerId, remoteStatusText ? ` - ${remoteStatusText}` : undefined] })), !callerId && remoteStatusText && (_jsx(Box, { fontScale: 'c1', color: 'secondary-info', children: remoteStatusText }))] })] }));
};
export default InternalUser;
//# sourceMappingURL=InternalUser.js.map