import { jsx as _jsx } from "react/jsx-runtime";
import { css } from '@rocket.chat/css-in-js';
import { Box, Icon, Palette } from '@rocket.chat/fuselage';
import { useDraggableWidget } from './WidgetDraggableContext';
const dragHandle = css `
	cursor: grab;

	background-color: ${Palette.surface['surface-tint'].toString()};
	color: ${Palette.text['font-default'].toString()};

	&:hover {
		background-color: ${Palette.surface['surface-neutral'].toString()};
		color: ${Palette.text['font-info'].toString()};
	}
	&:active {
		cursor: grabbing;
	}
`;
const WidgetHandle = (props) => {
    const { handleRef } = useDraggableWidget();
    return (_jsx(Box, Object.assign({ height: 20, display: 'flex', flexDirection: 'row', justifyContent: 'center', className: dragHandle, ref: handleRef }, props, { children: _jsx(Icon, { name: 'stacked-meatballs', size: 'x20' }) })));
};
export default WidgetHandle;
//# sourceMappingURL=WidgetHandle.js.map