import { useEffect, useState } from 'react';
import { useTranslation } from 'react-i18next';
const getMutedSlot = (muted, t) => {
    if (muted) {
        return {
            text: t('Muted'),
            type: 'warning',
        };
    }
    return undefined;
};
const getHeldSlot = (held, t) => {
    if (held) {
        return {
            text: t('On hold'),
            type: 'info',
        };
    }
    return undefined;
};
const getConnectionStateSlot = (connectionState, t) => {
    if (connectionState === 'RECONNECTING') {
        return {
            text: t('meteor_status_connecting'),
            type: 'warning',
            icon: 'warning',
        };
    }
    return undefined;
};
export const useInfoSlots = (muted, held, connectionState) => {
    const { t } = useTranslation();
    const [slots, setSlots] = useState([]);
    useEffect(() => {
        const slots = [];
        const heldSlot = getHeldSlot(held, t);
        const mutedSlot = getMutedSlot(muted, t);
        const connectionStateSlot = connectionState ? getConnectionStateSlot(connectionState, t) : undefined;
        if (connectionStateSlot) {
            slots.push(connectionStateSlot);
            setSlots(slots);
            return;
        }
        if (heldSlot) {
            slots.push(heldSlot);
        }
        if (mutedSlot) {
            slots.push(mutedSlot);
        }
        setSlots(slots);
    }, [muted, held, t, connectionState]);
    return slots;
};
//# sourceMappingURL=useInfoSlots.js.map