import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Divider, Box, TextInput, Field, FieldRow } from '@rocket.chat/fuselage';
import { useState } from 'react';
import { useTranslation } from 'react-i18next';
import { Keypad } from './components';
export const useKeypad = (onPress) => {
    const [open, setOpen] = useState(false);
    const [inputValue, setInputValue] = useState('');
    const { t } = useTranslation();
    const element = (_jsxs(Box, { display: 'flex', justifyContent: 'center', alignItems: 'center', w: '100%', flexDirection: 'column', mbe: 8, children: [_jsx(Field, { mbe: 8, children: _jsx(FieldRow, { children: _jsx(TextInput, { value: inputValue, readOnly: true, small: true, mi: 24 }) }) }), _jsx(Keypad, { onKeyPress: (...args) => {
                    setInputValue((inputValue) => inputValue + args[0]);
                    onPress(...args);
                } }), _jsx(Divider, { w: '100%' })] }));
    return {
        element: open ? element : null,
        buttonProps: {
            title: open ? t('Close_dialpad') : t('Open_dialpad'),
            onClick: () => setOpen((open) => !open),
        },
    };
};
//# sourceMappingURL=useKeypad.js.map