import { useSafeRefCallback } from '@rocket.chat/ui-client';
import { useCallback, useRef } from 'react';
const getRemoteStream = (instance) => {
    try {
        const mainCall = instance === null || instance === void 0 ? void 0 : instance.getMainCall();
        if (!mainCall) {
            return null;
        }
        if (mainCall.hidden) {
            return null;
        }
        return mainCall.getRemoteMediaStream();
    }
    catch (error) {
        console.error('MediaCall: useMediaStream - Error getting remote media stream', error);
        return null;
    }
};
const useMediaStream = (instance) => {
    const remoteStream = getRemoteStream(instance);
    const actualRef = useRef(null);
    return [
        useSafeRefCallback(useCallback((node) => {
            // TODO remove node check when useSafeRefCallback is updated from fuselage.
            if (!node) {
                return;
            }
            actualRef.current = node;
            if (!remoteStream) {
                return;
            }
            node.srcObject = remoteStream;
            node.play().catch((error) => {
                console.error('MediaCall: useMediaStream - Error playing media stream', error);
            });
            return () => {
                actualRef.current = null;
                node.pause();
                node.srcObject = null;
            };
        }, [remoteStream])),
        actualRef,
    ];
};
export default useMediaStream;
//# sourceMappingURL=useMediaStream.js.map