export const convertAvatarUrlToPng = (avatarUrl) => {
    return new Promise((resolve) => {
        if (!avatarUrl) {
            resolve('');
            return;
        }
        const image = new Image();
        const onLoad = () => {
            const canvas = document.createElement('canvas');
            canvas.width = image.width;
            canvas.height = image.height;
            const context = canvas.getContext('2d');
            if (!context) {
                resolve('');
                return;
            }
            context.drawImage(image, 0, 0);
            try {
                resolve(canvas.toDataURL('image/png'));
            }
            catch (e) {
                resolve('');
            }
        };
        const onError = () => resolve('');
        image.onload = onLoad;
        image.onerror = onError;
        image.crossOrigin = 'anonymous';
        image.src = avatarUrl;
    });
};
//# sourceMappingURL=convertAvatarUrlToPng.js.map