import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Button, ButtonGroup } from '@rocket.chat/fuselage';
import { useTranslation } from 'react-i18next';
import { useMediaCallContext } from '../MediaCallContext';
import { PeerInfo, Widget, WidgetFooter, WidgetHandle, WidgetHeader, WidgetContent, DevicePicker } from '../components';
const OutgoingCall = () => {
    const { t } = useTranslation();
    const { onEndCall, peerInfo, connectionState } = useMediaCallContext();
    // TODO: Figure out how to ensure this always exist before rendering the component
    if (!peerInfo) {
        throw new Error('Peer info is required');
    }
    const connecting = connectionState === 'CONNECTING';
    return (_jsxs(Widget, { children: [_jsx(WidgetHandle, {}), _jsx(WidgetHeader, { title: connecting ? t('meteor_status_connecting') : `${t('Calling')}...`, children: _jsx(DevicePicker, {}) }), _jsx(WidgetContent, { children: _jsx(PeerInfo, Object.assign({}, peerInfo)) }), _jsx(WidgetFooter, { children: _jsx(ButtonGroup, { stretch: true, children: _jsx(Button, { medium: true, name: 'phone', icon: 'phone-off', danger: true, flexGrow: 1, onClick: onEndCall, children: t('Cancel') }) }) })] }));
};
export default OutgoingCall;
//# sourceMappingURL=OutgoingCall.js.map