import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Button, ButtonGroup } from '@rocket.chat/fuselage';
import { useTranslation } from 'react-i18next';
import { useMediaCallContext } from '../MediaCallContext';
import { PeerInfo, Widget, WidgetFooter, WidgetHandle, WidgetHeader, WidgetContent, DevicePicker, WidgetInfo } from '../components';
const OutgoingCallTransfer = () => {
    const { t } = useTranslation();
    const { onEndCall, peerInfo, connectionState, transferredBy } = useMediaCallContext();
    if (!peerInfo) {
        throw new Error('Peer info is required');
    }
    const connecting = connectionState === 'CONNECTING';
    return (_jsxs(Widget, { children: [_jsx(WidgetHandle, {}), _jsx(WidgetHeader, { title: connecting ? t('meteor_status_connecting') : `${t('Transferring_call')}...`, children: _jsx(DevicePicker, {}) }), transferredBy && _jsx(WidgetInfo, { slots: [{ text: t('Transferred_call__from__to', { from: transferredBy }), type: 'info' }] }), _jsx(WidgetContent, { children: _jsx(PeerInfo, Object.assign({}, peerInfo)) }), _jsx(WidgetFooter, { children: _jsx(ButtonGroup, { stretch: true, children: _jsx(Button, { medium: true, name: 'phone', icon: 'phone-off', danger: true, flexGrow: 1, onClick: onEndCall, children: t('Cancel') }) }) })] }));
};
export default OutgoingCallTransfer;
//# sourceMappingURL=OutgoingCallTransfer.js.map