import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { ButtonGroup, Divider } from '@rocket.chat/fuselage';
import { useLoginServices, useSetting } from '@rocket.chat/ui-contexts';
import { useTranslation } from 'react-i18next';
import LoginServicesButton from './LoginServicesButton';
const LoginServices = ({ disabled, setError, }) => {
    const { t } = useTranslation();
    const services = useLoginServices();
    const showFormLogin = useSetting('Accounts_ShowFormLogin');
    if (services.length === 0) {
        return null;
    }
    return (_jsxs(_Fragment, { children: [showFormLogin && _jsx(Divider, { mb: 24, p: 0, children: t('registration.component.form.divider') }), _jsx(ButtonGroup, { vertical: true, stretch: true, small: true, children: services.map((service) => (_jsx(LoginServicesButton, Object.assign({ disabled: disabled }, service, { setError: setError }), service.service))) })] }));
};
export default LoginServices;
//# sourceMappingURL=LoginServices.js.map