import { jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import { useSession } from '@rocket.chat/ui-contexts';
import GuestForm from './GuestForm';
import { LoginForm } from './LoginForm';
import RegisterSecretPageRouter from './RegisterSecretPageRouter';
import RegisterTemplate from './RegisterTemplate';
import ResetPasswordForm from './ResetPasswordForm';
import { useLoginRouter } from './hooks/useLoginRouter';
export const RegistrationPageRouter = ({ defaultRoute = 'login', children, }) => {
    const defaultRouteSession = useSession('loginDefaultState');
    const [route, setLoginRoute] = useLoginRouter(defaultRouteSession || defaultRoute);
    if (route === 'guest') {
        return (_jsx(RegisterTemplate, { children: _jsx(GuestForm, { setLoginRoute: setLoginRoute }) }));
    }
    if (route === 'login') {
        return (_jsx(RegisterTemplate, { children: _jsx(LoginForm, { setLoginRoute: setLoginRoute }) }));
    }
    if (route === 'reset-password') {
        return (_jsx(RegisterTemplate, { children: _jsx(ResetPasswordForm, { setLoginRoute: setLoginRoute }) }));
    }
    if (route === 'secret-register' || route === 'register' || route === 'invite-register') {
        return _jsx(RegisterSecretPageRouter, { origin: route, setLoginRoute: setLoginRoute });
    }
    if (route === 'anonymous') {
        return _jsx(_Fragment, { children: children });
    }
    return null;
};
export default RegistrationPageRouter;
//# sourceMappingURL=RegistrationPageRouter.js.map