import { jsx as _jsx } from "react/jsx-runtime";
import { useRouteParameter } from '@rocket.chat/ui-contexts';
import RegisterForm from './RegisterForm';
import SecretRegisterInvalidForm from './SecretRegisterInvalidForm';
import { useCheckRegistrationSecret } from './hooks/useCheckRegistrationSecret';
import FormSkeleton from './template/FormSkeleton';
import HorizontalTemplate from './template/HorizontalTemplate';
const SecretRegisterForm = ({ setLoginRoute }) => {
    const hash = useRouteParameter('hash');
    const { data: valid, isSuccess } = useCheckRegistrationSecret(hash);
    if (isSuccess && !valid) {
        return _jsx(SecretRegisterInvalidForm, {});
    }
    if (isSuccess && valid) {
        return (_jsx(HorizontalTemplate, { children: _jsx(RegisterForm, { setLoginRoute: setLoginRoute }) }));
    }
    return (_jsx(HorizontalTemplate, { children: _jsx(FormSkeleton, {}) }));
};
export default SecretRegisterForm;
//# sourceMappingURL=SecretRegisterForm.js.map