import { jsx as _jsx } from "react/jsx-runtime";
import { Box } from '@rocket.chat/fuselage';
import { HorizontalWizardLayoutCaption } from '@rocket.chat/layout';
import { useSetting } from '@rocket.chat/ui-contexts';
import DOMPurify from 'dompurify';
import { useTranslation } from 'react-i18next';
export const LoginTerms = () => {
    const { t } = useTranslation();
    const loginTerms = useSetting('Layout_Login_Terms', '');
    return (_jsx(HorizontalWizardLayoutCaption, { children: _jsx(Box, { color: 'default', withRichContent: true, dangerouslySetInnerHTML: {
                __html: loginTerms !== '' ? DOMPurify.sanitize(loginTerms) : DOMPurify.sanitize(t('Layout_Login_Terms_Content')),
            } }) }));
};
export default LoginTerms;
//# sourceMappingURL=LoginTerms.js.map