"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sequence = void 0;
function sequence() {
    var methods = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        methods[_i] = arguments[_i];
    }
    if (methods.length === 0) {
        throw new Error("Failed creating sequence: No functions provided");
    }
    return function __executeSequence() {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        var result = args;
        var _this = this;
        while (methods.length > 0) {
            var method = methods.shift();
            result = [method.apply(_this, result)];
        }
        return result[0];
    };
}
exports.sequence = sequence;
