(function (root, factory) {
  if (typeof define === "function" && define.amd) {
    // AMD. Register as an anonymous module.
    define([], factory);
  } else if (typeof module === "object" && module.exports) {
    // Node. Does not work with strict CommonJS, but
    // only CommonJS-like environments that support module.exports,
    // like Node.
    module.exports = factory();
  } else {
    // Browser globals (root is window)
    root.hyphenationPatternsLaXLiturgic = factory();
  }
})(this, function () {
  var patterns = [],
    hyphenation = [];

  // copyright: Copyright (C) 2016-2017 Claudio Beccari, Elie Roux
  // title: Hyphenation patterns for liturgical Latin
  // notice: This file is part of the hyph-utf8 package.
  //     See http://www.hyphenation.org/tex for more information.
  // language:
  //     name: Liturgical Latin
  //     tag: la-x-liturgic
  // version: 2017-09-13
  // authors:
  //     -
  //         name: Claudio Beccari
  //         contact: claudio.beccari (at) gmail.com
  //     -
  //         name: Monastery of Solesmes
  //     -
  //         name: Élie Roux
  //         contact: elie.roux (at) telecom-bretagne.eu
  // licence:
  //   -
  //     name: MIT
  //     url: https://opensource.org/licenses/MIT
  //     text: >
  //         Permission is hereby granted, free of charge, to any person obtaining
  //         a copy of this software and associated documentation files (the
  //         "Software"), to deal in the Software without restriction, including
  //         without limitation the rights to use, copy, modify, merge, publish,
  //         distribute, sublicense, and/or sell copies of the Software, and to
  //         permit persons to whom the Software is furnished to do so, subject to
  //         the following conditions:
  //
  //         The above copyright notice and this permission notice shall be
  //         included in all copies or substantial portions of the Software.
  //
  //         THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  //         EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  //         MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  //         NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
  //         BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
  //         ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  //         CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  //         SOFTWARE.
  var patterns = [
    ".a3b3æq",
    ".a2b1ali",
    ".a2b1auu",
    ".a2b3c",
    ".a2b1eo",
    ".á2b1eo",
    ".a2b1er",
    ".a2b1ér",
    ".a4b3es",
    ".a2b1eu",
    ".a2b1eú",
    ".a2b1éu",
    ".a2bfu",
    ".a2b1í",
    ".a2b1ic",
    ".a2b1i2ec",
    ".a2b1i2éc",
    ".a2b3ier",
    ".a2b3iér",
    ".a2b1ig",
    ".á2b3ig",
    ".a2b1i2i",
    ".a2b1i2í",
    ".á2b1i2i",
    ".a2b1in1",
    ".a2b1ir",
    ".a2b1it",
    ".á2b1it",
    ".a2b1i4u",
    ".a2b1i4ú",
    ".a2b1iv",
    ".a2bj",
    ".a2b3l",
    ".á2b3lu",
    ".a2b1ol",
    ".a2b1ól",
    ".a2b1om",
    ".a2b1or",
    ".a2b1ór",
    ".a2b1ort",
    ".a2b3r",
    ".á2b3r",
    ".a3b4rah",
    ".á3b4rah",
    ".a2b3ru",
    ".ab4s3c",
    ".áb4s3c",
    ".ab5s4ce",
    ".ab5s4cé",
    ".ab5s4ci",
    ".ab5s4cí",
    ".ab5s4cis",
    ".ab5s4cin",
    ".ab5s4cín",
    ".ab3s2en",
    ".ab3s2én",
    ".ab3si2",
    ".ab5s4i3d",
    ".áb5s4i3d",
    ".ab5si3l",
    ".ab5si3m",
    ".ab3so",
    ".ab3só",
    ".ab5s4on",
    ".ab5s4ón",
    ".áb5s4on",
    ".ab4s3tem",
    ".ab4s3tém",
    ".ab3s2ten",
    ".ab4s3ter",
    ".ab4s3tér",
    ".ab4s3tin",
    ".ab4s3tín",
    ".áb4s3tin",
    ".ab4s3tr",
    ".áb4s3tr",
    ".ab4s3tu",
    ".ab4s3tú",
    ".ab3su2",
    ".ab5su3m",
    ".a2b3und",
    ".a2b3únd",
    ".a2b3us",
    ".a2b3ut",
    ".a2b3út",
    ".a2d3",
    ".á2d3",
    ".a3d4æ",
    ".a4d5æq",
    ".a3d4am.",
    ".a2d3a3s4cr",
    ".a3d4eps",
    ".ader2",
    ".a2dfu",
    ".adi2a",
    ".ádi2a",
    ".adi2á",
    ".a3d4i3ab",
    ".a3d4i3áb",
    ".adi2e",
    ".adi2é",
    ".adi3eu",
    ".ad3i2i",
    ".ad3i2í",
    ".adi2o",
    ".ádi2o",
    ".a3d4ip",
    ".a3d4íp",
    ".á3d4ip",
    ".a4d5ipisc",
    ".a4d5ipísc",
    ".ad5is.",
    ".ad5it.",
    ".ad3i2u",
    ".ad3i2ú",
    ".ádi2u",
    ".a4d3ole",
    ".a3d4on",
    ".a3d4ón",
    ".a3d4ran",
    ".a3d4rán",
    ".á3d4ran",
    ".ad3s2cr",
    ".ad3si",
    ".a2d5s2t",
    ".á2d5s2tr",
    ".adsu3e",
    ".a3d4u3a",
    ".a3d4u3á",
    ".a4d5ul",
    ".a3d4urn",
    ".a3d4y",
    ".a3d4ý",
    ".á3d4y",
    ".alte3r",
    ".alté3r",
    ".álte3r",
    ".alte4rc",
    ".alté4rc",
    ".alte4rn",
    ".alté4rn",
    ".alte4rp",
    ".alté4rp",
    ".alte4rt",
    ".alte4r3ut",
    ".alté4r3ut",
    ".alte4r3út",
    ".ani2m3ad",
    ".anti1",
    ".anti3m2n",
    ".ape3r2u",
    ".archi3e",
    ".a3s2c",
    ".á3s2c",
    ".a3s2p",
    ".á3s2p",
    ".a4s3pid",
    ".á4s3pid",
    ".a4s3per",
    ".á4s3per",
    ".a5s4perg",
    ".a5s4pern",
    ".a5s2t",
    ".a5s4tern",
    ".a5s4tip",
    ".a5s4tr",
    ".a5s4tu",
    ".a5s4tú",
    ".b2",
    ".beni4a",
    ".béni4a",
    ".be4th5l",
    ".bé4th5l",
    ".c2",
    ".ce4u.",
    ".circu4m1",
    ".circú4m1",
    ".circumi2a",
    ".circumi2á",
    ".circumi2e",
    ".circumi2i",
    ".circumi2í",
    ".circumi2n3i4i",
    ".circumi2o",
    ".circumi2u",
    ".circum5s4",
    ".circú4m5s4",
    ".ci2s3",
    ".co1e",
    ".co3e2lec",
    ".co3e2lig",
    ".co3emen",
    ".co2e1n",
    ".co3e2r",
    ".co3e2x3",
    ".coex3s2",
    ".co3g2nos",
    ".co3g2nós",
    ".co1i",
    ".co1i2e",
    ".coi3u",
    ".co2m3ed",
    ".co2m3éd",
    ".có2m3ed",
    ".co2m3es.",
    ".co2m3it",
    ".co2m3ít",
    ".có2m3it",
    ".co2n1",
    ".có2n1",
    ".co3n2a",
    ".co3n2á",
    ".co3n2e",
    ".co3n2é",
    ".co3n2i",
    ".co3n2í",
    ".coni2a",
    ".con3ic",
    ".coni2e",
    ".co6n5i4ec",
    ".co6n5i4éc",
    ".co6n3i4i",
    ".co6n3i4í",
    ".co4n3i2u",
    ".co4n3i2ú",
    ".có4n3i2u",
    ".co3n2o",
    ".co3n2ó",
    ".con3s2cr",
    ".cón3s2cr",
    ".con3s2p2",
    ".cón3s2p2",
    ".con5s4t",
    ".cón5s4t",
    ".co3n2u",
    ".co3n2ú",
    ".cu4m5s4cr",
    ".cu4sp",
    ".de1í",
    ".dé1i",
    ".de1in",
    ".de1ín",
    ".de1it",
    ".depe4r5",
    ".depé4r5",
    ".de3s2c",
    ".de3s2p",
    ".dé3s2p",
    ".de3s2q",
    ".de5s2tit",
    ".de5s2tít",
    ".de5s2til",
    ".de5s2tíl",
    ".de5s2tru",
    ".de5s2trú",
    ".dé5s2tru",
    ".de4uter",
    ".di3g2nosc",
    ".di3i4u",
    ".di3i4ú",
    ".di3œ",
    ".di2r1im",
    ".di2r1ím",
    ".di4s3",
    ".dí4s3",
    ".di5s4ced",
    ".di5s4céd",
    ".di5s4cen",
    ".di5s4cén",
    ".di5s4cep",
    ".di5s4cép",
    ".di5s4cer",
    ".di5s4cér",
    ".di5s4ces",
    ".di5s4cés",
    ".di5s4cid",
    ".di5s4cíd",
    ".di5s4cin",
    ".di5s4cín",
    ".di5s4cip",
    ".di5s4cíp",
    ".di5s4ciss",
    ".di5s4císs",
    ".di5s4cit",
    ".dí5s4cit",
    ".di5s4cr",
    ".di6s5cre",
    ".di6s5cré",
    ".di6s5crim",
    ".di6s5crím",
    ".di6s5cru",
    ".di6s5cruc",
    ".di6s5crúc",
    ".di5s4ert",
    ".di5s4ért",
    ".di2s1i2",
    ".di2s1í2",
    ".disi3c",
    ".disí3c",
    ".di2sj",
    ".di5s4pe",
    ".di5s4pé",
    ".di6s5pen",
    ".di6s5pén",
    ".di6s5per",
    ".di6s5pér",
    ".dispe4r5e",
    ".dispé4r5e",
    ".dispe4r5i",
    ".dispé4r5i",
    ".di7s6pers",
    ".di7s6pérs",
    ".di7s6perg",
    ".di7s6pérg",
    ".di5s4pi",
    ".di5s4pí",
    ".di5s4ta",
    ".di5s4tá",
    ".di5s4tin",
    ".di5s4tín",
    ".di6s5tine",
    ".di6s5tíne",
    ".di5s4tir",
    ".di5s4tír",
    ".di5s4to.",
    ".di5s4tric",
    ".di5s4tríc",
    ".di5s4trin",
    ".di5s4trín",
    ".di3u",
    ".di3ú",
    ".ele2uth",
    ".elé2uth",
    ".e2t3en",
    ".é2t3en",
    ".e2t3i3am",
    ".é2t3i3am",
    ".e2t3i3ám",
    ".e4u",
    ".e4ú",
    ".é4u",
    ".e5um",
    ".e5úm",
    ".e5un",
    ".e5ún",
    ".e6unu",
    ".e6únu",
    ".e5us.",
    ".e2x3",
    ".é2x3",
    ".e3x4ed",
    ".é3x4ed",
    ".e3x4éd",
    ".e3x4eget",
    ".e3x4egét",
    ".e3x4od",
    ".é3x4od",
    ".e3x4ód",
    ".e3x4orc",
    ".ex5s4c",
    ".éx5s4c",
    ".exs2p",
    ".éxs2p",
    ".ex5s2t",
    ".éx5s2t",
    ".f2",
    ".g2",
    ".h2",
    ".haru3s4p",
    ".harú3s4p",
    ".he3i.",
    ".he3u.",
    ".hi2e",
    ".hi2é",
    ".hucu4s",
    ".hu1i2u",
    ".hu1i2ú",
    ".i4a",
    ".i4á",
    ".iai2u",
    ".i3bi",
    ".i3bí",
    ".i3bo",
    ".i3bó",
    ".i3bu",
    ".i3bú",
    ".i3co",
    ".i3có",
    ".i2d1",
    ".i2dci",
    ".i3d2e",
    ".i3d2é",
    ".í3d2e",
    ".i4d3em",
    ".i5den",
    ".i4d3eo.",
    ".í4d3eo.",
    ".i4d3eoq",
    ".i4d3eóq",
    ".i4d3es",
    ".i3d2ib",
    ".i3di2og",
    ".i3d2ol",
    ".i3d2ól",
    ".i3d2on",
    ".i3d2ón",
    ".i3d2us",
    ".i2e",
    ".i2é",
    ".iei2u",
    ".i3i",
    ".i3í",
    ".í3i",
    ".i4n3",
    ".í4n3",
    ".ina2b3r",
    ".inab3s2",
    ".ina2cr",
    ".ina2df",
    ".i3n2an",
    ".i3n2án",
    ".incircu4m",
    ".in4d3ep",
    ".in4d3ép",
    ".in4d3ig",
    ".ín4d3ig",
    ".in5d4ign",
    ".in5d4ígn",
    ".in4d3ipis",
    ".in4d3ipís",
    ".in5d4is",
    ".in4d3u",
    ".ín4d3u",
    ".in4d3ú",
    ".in5d4uc",
    ".in5d4úc",
    ".in5d4ul",
    ".in5d4úl",
    ".in5d4um",
    ".in5d4úm",
    ".in5d4us",
    ".in5d4ús",
    ".in5d4ux",
    ".in5d4úx",
    ".i3n2ers",
    ".i3n2ert",
    ".ine2x3",
    ".inexs2t",
    ".infra3s4",
    ".ini2e",
    ".ini2é",
    ".ini2í",
    ".i3n2it",
    ".ini2u",
    ".ini2ú",
    ".ino2b3",
    ".ino3b2oe",
    ".ino2b3œ",
    ".inob3s2c",
    ".inpe2r3iur",
    ".in3s4cr",
    ".in3s2p",
    ".in5s2t",
    ".ín5s2t",
    ".inte2r3e",
    ".inte2r3é",
    ".inté2r3e",
    ".inte3r4em",
    ".inte3r4ém",
    ".inte3r4en",
    ".inte3r4én",
    ".inte3r4er",
    ".inté3r4er",
    ".inte3r4ér",
    ".inte3r4es",
    ".inte4r5ess",
    ".inte3r4et",
    ".inte3r4ét",
    ".inte2r3i",
    ".inte2r3í",
    ".inté2r3i",
    ".ínte2r3i",
    ".interi2a",
    ".interi2á",
    ".interi2e",
    ".interí2e",
    ".interi2é",
    ".interi2i",
    ".interi2í",
    ".inte3r4i3or",
    ".inte3r4i3ór",
    ".inté3r4i3or",
    ".interi2u",
    ".interi2ú",
    ".inte3r4ius.",
    ".inté3r4ius.",
    ".inte2r3s4pe",
    ".inte2r3s4pé",
    ".intro3i3e",
    ".intro3i3é",
    ".intro3s4p",
    ".inu2a",
    ".inu2e",
    ".inu2i",
    ".i3n2ul",
    ".i4n3ulc",
    ".inu2o",
    ".inu2u",
    ".i2o",
    ".i2ó",
    ".i4u",
    ".i4ú",
    ".iu2s3i2ur",
    ".j2",
    ".l2",
    ".la4u",
    ".lecti5s4t",
    ".lon2g1an",
    ".lon2g1án",
    ".lu4x3q",
    ".lu3x2u",
    ".lu3x2ú",
    ".m2",
    ".mai4u",
    ".n2",
    ".ne2c1op",
    ".ne2c1óp",
    ".ne2g1ot",
    ".ne2g1ót",
    ".ne2u.",
    ".ne2ut",
    ".né2ut",
    ".o2b1",
    ".ó2b1",
    ".o3b2ed",
    ".o3b2éd",
    ".o3b2el",
    ".o3b2es",
    ".obi2a",
    ".o3b2ic",
    ".o4b3ici",
    ".obi2e",
    ".obi2é",
    ".obi3er",
    ".o3b2ig",
    ".ob3i4i",
    ".ob3i4í",
    ".ob3i2u",
    ".ob3i2ú",
    ".ob3l",
    ".ób3l",
    ".o4b3œ",
    ".ob3r",
    ".ób3r",
    ".ób3ru",
    ".o3b4ruz",
    ".ob3s2c",
    ".ob3s2cu",
    ".ob5s2t",
    ".ób5s2t",
    ".ob3tr",
    ".obu2a",
    ".obu2e",
    ".obu2i",
    ".obu2o",
    ".p2",
    ".pæ2n3ins",
    ".pæ2n3íns",
    ".para1i",
    ".para1u",
    ".pe1i6or",
    ".pe1i6ór",
    ".pe2r1absu",
    ".pe2r1ac",
    ".pe2r1ác",
    ".pe2r1a2dp",
    ".pe2r1a2d1u",
    ".pe2r1ae",
    ".pe2r3ag",
    ".pe2r3ág",
    ".pé2r3ag",
    ".pe2r1ama",
    ".pe2r1amá",
    ".pe2r1amb",
    ".pe2r1ámb",
    ".pe4r3ant",
    ".pe2r1ar",
    ".pe2r1ár",
    ".pe2r1a2u",
    ".pe2r1coq",
    ".pe2r1cu",
    ".pe2r3ea",
    ".pe2r3eám",
    ".pé2r3eam",
    ".pé2r3eant",
    ".pe2r3eát",
    ".pé2r3eat",
    ".pe2r3eas",
    ".pé2r3eas",
    ".pe4r3ec",
    ".pe4r1ed",
    ".pe2r1eff",
    ".pe2r3ég",
    ".pe6r3egr",
    ".pé6r3egr",
    ".pe2r1el",
    ".pe2r1em",
    ".pe2r1ém",
    ".pe4r5end",
    ".pe4r5énd",
    ".pe4r3enn",
    ".pe4r3énn",
    ".pe2r3eo",
    ".pé2r3eo",
    ".pe4r3err",
    ".pe4r3érr",
    ".pe2r1eru",
    ".pe2r3es.",
    ".pe2r3eu",
    ".pe2r3eú",
    ".pé2r3eu",
    ".pe4r1e2x3",
    ".pe2r3h",
    ".pé2r3h",
    ".pe2r3i1",
    ".pe2r3í1",
    ".pe3r4ia",
    ".pe3r4iá",
    ".pe2r1i2ac",
    ".pe3r4ian",
    ".pe2r3ib",
    ".pe2r3íb",
    ".pe3r4icl",
    ".pe3r4ícl",
    ".pe3r4icu",
    ".pe3r4ícu",
    ".pe2r3ie",
    ".pe2r3íe",
    ".pe2r3ié",
    ".pe3r4ieb",
    ".pe3r4iéb",
    ".pe3r4iem",
    ".pe3r4iém",
    ".pe3r4ien",
    ".pe3r4ién",
    ".pe4r5iens",
    ".pé4r5iens",
    ".pe3r4ier",
    ".pe3r4íer",
    ".pe3r4iér",
    ".pe4r5iera",
    ".pé4r5iera",
    ".pe4r5íera",
    ".pe5r6ierat",
    ".pé5r6ierat",
    ".pe5r6íerat",
    ".perie3i",
    ".pe3r4iet",
    ".pe3r4iét",
    ".perié3i",
    ".períe3i",
    ".pe2r1i2ec",
    ".pé2r3ii",
    ".per5iit",
    ".pér5iit",
    ".pe4r3im",
    ".pe4r3ím",
    ".pé4r3im",
    ".pe5r4imi",
    ".pe5r4ími",
    ".pe5r4imu",
    ".pe5r4ímu",
    ".pe6r5imus",
    ".pe6r5ímus",
    ".pe2r3in",
    ".pe2r3ín",
    ".pe3r4int",
    ".pe3r4ínt",
    ".pe3r4io",
    ".pe3r4iod",
    ".pe3r4iód",
    ".peri3p2s",
    ".peri3p2t",
    ".pe2r3ir",
    ".pe2r3ír",
    ".pe3r4iremur",
    ".pe3r4irémur",
    ".pe3r4iremi",
    ".pe3r4irémi",
    ".pe3r4irentur",
    ".pe3r4iréntur",
    ".pe3r4irer",
    ".pe3r4irér",
    ".pe3r4írer",
    ".pe3r4iret",
    ".pe3r4irét",
    ".pe4r5iret.",
    ".pe4r5iretis",
    ".pe4r5irétis",
    ".pe3r4iri",
    ".pe3r4íri",
    ".pe3r4i3s2c",
    ".pe3r4í3s2c",
    ".peri3s2t",
    ".pe3r4it",
    ".pe3r4ít",
    ".pe4r5itúr",
    ".pe4r5itur",
    ".pe4r5ítur",
    ".pe4r5it.",
    ".pe4r5itote",
    ".pe4r5itóte",
    ".pe2r3i4u",
    ".pe2r3i4ú",
    ".pe3r4i5un",
    ".pe3r4i5ún",
    ".pe4r3j",
    ".pé4r3j",
    ".pe2r1o2b3s2c",
    ".pe2r1od",
    ".pe2r1of",
    ".pe2r1ol",
    ".pe2r1op",
    ".pe4r3or",
    ".pe4r3ór",
    ".pe2r3reg",
    ".pe2r3s2c",
    ".pe2r3s2p",
    ".pe2r7s2t",
    ".pé2r7s2t",
    ".pe2r3tran2s1",
    ".pe2r3trán2s1",
    ".pe2r3u",
    ".pe2r3ú",
    ".pe2r1u2a",
    ".pe2r1u2e",
    ".pe2r1u2i",
    ".pe3r4ul",
    ".pe3r4úl",
    ".pe2r1u2o",
    ".pne4u",
    ".po3et",
    ".pos4t3ea",
    ".pos4t3eá",
    ".pós4t3ea",
    ".pos4t3er",
    ".pos4t3ér",
    ".pós4t3er",
    ".pos4t3h",
    ".po4s4t3hac",
    ".pos4t3il",
    ".pos4t3íl",
    ".posu3í",
    ".pósu3i",
    ".po2t3e",
    ".po2t3é",
    ".pó2t3e",
    ".po4t3ue",
    ".po4t3ui",
    ".po4t3úe",
    ".po4t3úi",
    ".po4t3ué",
    ".po4t3uí",
    ".pó4t3ui",
    ".præ1",
    ".præ3a2u",
    ".præ3es",
    ".præi4a",
    ".præi4á",
    ".præi4ec",
    ".præi4o",
    ".præi4i",
    ".præi4í",
    ".præi4u",
    ".præi4ú",
    ".præ3s2c",
    ".præ3s2p",
    ".præ5s2t",
    ".præte2r1",
    ".præté2r1",
    ".primi1",
    ".primi3s2c",
    ".pro2d1ea",
    ".pró2d1ea",
    ".pro1de1amb",
    ".pro2d1eo",
    ".pró2d1eo",
    ".pro2d1es3s",
    ".pro2d1és3s",
    ".pro2d1eun",
    ".pro2d1fu2",
    ".pro2d1ib",
    ".pro3d2i3d",
    ".pro3d2í3d",
    ".pro2d1ien",
    ".pro2d1ién",
    ".pró2d1ien",
    ".pro2d1ier",
    ".pro2d1iér",
    ".pró2d1ier",
    ".pro2d1ig",
    ".pro2d1íg",
    ".pró2d1ig",
    ".pro2d3ii.",
    ".pró2d3ii.",
    ".pro2d1im",
    ".pro2d1ir",
    ".pro2d1ír",
    ".pro2d3is",
    ".pro2d3ís",
    ".pro2d5it",
    ".pro2d5ít",
    ".pro3d6iti",
    ".pro3d6íti",
    ".pro3d6ito",
    ".pro3d6íto",
    ".pro3d6itr",
    ".pro3g2n",
    ".pro3i4e",
    ".pro3i4é",
    ".pro3i4i",
    ".pro3i4í",
    ".pró3i4i",
    ".pro3in",
    ".propte2r3",
    ".propté2r3",
    ".pro3s2c",
    ".pro3s2p",
    ".pró3s2p",
    ".pro5s2t",
    ".pro5s4tan",
    ".pro5s4tar",
    ".pro4s3tit",
    ".pro4s3tra",
    ".pro4s3trá",
    ".pro3u",
    ".pse4udo",
    ".qua2m3o2b3",
    ".que2m3a2d3m",
    ".que2m3á2d3m",
    ".quin2c3un",
    ".quoa2d3usq",
    ".quoa2d3úsq",
    ".quo6d5l",
    ".quo6n3iam",
    ".quó6n3iam",
    ".quo2t1an",
    ".quo2t1enn",
    ".quo2t3li",
    ".r2",
    ".ra2y",
    ".re2d1ac",
    ".re2d1ác",
    ".re2d1ad",
    ".re2d1ád",
    ".re2d1am",
    ".re2d1ám",
    ".re2d1amb",
    ".re2d1ámb",
    ".re2d1an",
    ".re2d1án",
    ".re2d1ar",
    ".re2d1ár",
    ".re2d1arg",
    ".re2d1árg",
    ".re2d1a2u",
    ".re2d1á2u",
    ".re2d1ea",
    ".ré2d1ea",
    ".re2d1eá",
    ".re2d1eg",
    ".re2d1ég",
    ".re2d1em",
    ".re2d1ém",
    ".re2d1eo",
    ".ré2d1eo",
    ".re2d1eu",
    ".re2d1eú",
    ".ré2d1eu",
    ".re2d1h",
    ".re2d1i.",
    ".re2d1ib",
    ".re2d1íb",
    ".re3d2ic",
    ".re2d1ien",
    ".ré2d1ien",
    ".re2d1ier",
    ".re2d1íer",
    ".re2d1iér",
    ".re2d1ii",
    ".ré2d1ii",
    ".re2d1íi",
    ".re2d1ií",
    ".re2d1ig",
    ".ré2d1ig",
    ".re2d1im",
    ".re2d1ím",
    ".ré2d1im",
    ".re4d3imi",
    ".re2d1in",
    ".re2d1ín",
    ".re2d1ir",
    ".re2d1ír",
    ".re2d5is",
    ".re2d5it",
    ".re2d5ít",
    ".ré2d5it",
    ".re2d1iv",
    ".re2d1ív",
    ".re2d1ol",
    ".re2d1ól",
    ".ré2d1ol",
    ".re2d1op",
    ".re2d1óp",
    ".re2d1ord",
    ".re2d1órd",
    ".re3d2orm",
    ".re2d1orn",
    ".re2d1órn",
    ".re2d1ul",
    ".re2d1úl",
    ".re2d1un",
    ".re2d1ún",
    ".re2d1uv",
    ".re2d1úv",
    ".ree2x",
    ".re1ie",
    ".re3i2ec",
    ".re1in",
    ".re3ips",
    ".re3ite",
    ".repa2u",
    ".re3s2cr",
    ".re3s2cu",
    ".re3s2cú",
    ".re4s3pu4b3l4ic",
    ".re4s3pú4b3l4ic",
    ".re3s2p",
    ".ré3s2p",
    ".re3s2pec",
    ".re3s2péc",
    ".re5s4ta",
    ".re5s4tá",
    ".re5s2tag",
    ".re5s4ta2u",
    ".re5s2ter",
    ".re5s2tér",
    ".re5s2tib",
    ".re5s2tíb",
    ".re5s2tic",
    ".re6s3ticu",
    ".re5s2til",
    ".re5s2tin",
    ".re5s2tín",
    ".re5s2tip",
    ".re5s2típ",
    ".ré5s4tit",
    ".re5s4tit",
    ".re5s4tít",
    ".re5s2to",
    ".re5s4tr",
    ".ré5s4tr",
    ".s2",
    ".sa2t1ag",
    ".sa2t1ág",
    ".sati2s1",
    ".sa3ul.",
    ".seme2t3ip",
    ".se2m3un",
    ".se2m3us",
    ".se3s4cen",
    ".ses2c1u4n",
    ".se4u.",
    ".si2c1ut",
    ".sí2c1ut",
    ".si3s2ten",
    ".s2m",
    ".sta3g2n",
    ".su2b3",
    ".sú2b3",
    ".subi4a",
    ".subi4á",
    ".subi4e",
    ".subi4é",
    ".subi4i",
    ".subi4í",
    ".súbi4i",
    ".subi4u",
    ".subi4ú",
    ".sub5s4cr",
    ".sub5s4t",
    ".súb5s4t",
    ".subte2r3h",
    ".su3b4ul",
    ".sú3b4ul",
    ".su4b5ulc",
    ".su4b5ult",
    ".supe2r1ab",
    ".supé2r1ab",
    ".supe2r1áb",
    ".supe3r2aba",
    ".supe3r2abá",
    ".supe3r2ába",
    ".supe3r2abe",
    ".supe3r2ábe",
    ".supe3r2abi",
    ".supe3r2ábi",
    ".supe3r2abí",
    ".supera2b3l",
    ".superá2b3l",
    ".supe3r2abo",
    ".supe3r2ábo",
    ".supe3r2abu",
    ".supe3r2ábu",
    ".supé3r2abu",
    ".supe3r2abú",
    ".supe4r3a2b3um",
    ".supe4r3a2b3und",
    ".supe4r3a2b3únd",
    ".supe2r1ac",
    ".supe2r1ad",
    ".supé2r1ad",
    ".supe2r1ád",
    ".supera2d1i2i",
    ".supera2d1i2í",
    ".supe2r1ad3s2t",
    ".supé2r1ad3s2t",
    ".supe3r2æ.",
    ".supé3r2æ.",
    ".supe2r1æ",
    ".supé2r1æ",
    ".supe2r1ag",
    ".supe2r1ág",
    ".supé2r1ag",
    ".supe2r1all",
    ".supe2r1áll",
    ".supe3r2am",
    ".supé3r2am",
    ".supe4r3amb",
    ".supe4r3ámb",
    ".supe3r2and",
    ".supe3r2ánd",
    ".supe4r3ap",
    ".supe2r1arg",
    ".supé2r1arg",
    ".supe2r1asc",
    ".supe2r1a3s2p",
    ".supé2r1a3s2p",
    ".supe2r1a3s2t",
    ".supé2r1a3s2t",
    ".supe2r1att",
    ".supé2r1att",
    ".supe2r1bib",
    ".supé2r1bib",
    ".supe2r1bif",
    ".supé2r1bif",
    ".supe2r1bil",
    ".supé2r1bil",
    ".supe2r1c",
    ".supé2r1c",
    ".supe2r1d",
    ".supé2r1d",
    ".supe2r1ed",
    ".supé2r1ed",
    ".supe2r1eff",
    ".supé2r1eff",
    ".supe2r1éff",
    ".supe2r1eg",
    ".supé2r1eg",
    ".supe2r1el",
    ".supe2r1él",
    ".supe2r1em",
    ".supe2r1ém",
    ".supé2r1em",
    ".supe3r2em.",
    ".supe3r2emini.",
    ".supe3r2émini.",
    ".supe3r2emu",
    ".supe3r2ému",
    ".supe2r1en",
    ".supé2r1en",
    ".supe2r1én",
    ".supe3r2ent",
    ".supe3r2ént",
    ".supe2r1er",
    ".supé2r1er",
    ".supe3r2er.",
    ".supe3r2ere.",
    ".supe3r2eris.",
    ".supé3r2eris.",
    ".supe2r1es",
    ".supe2r1és",
    ".súpe2r1es",
    ".super3es.",
    ".súper3es.",
    ".supe2r1eu",
    ".supe2r1ev",
    ".supe2r1év",
    ".supe2r1e2x3",
    ".supé2r1e2x3",
    ".supe2r3h",
    ".supe3r4i.",
    ".supé3r4i.",
    ".supe2r3i2",
    ".supé2r3i2",
    ".supe2r1il",
    ".supe2r1íl",
    ".supe2r1im",
    ".supe3r4i3mini.",
    ".supe2r1in",
    ".superin3i4i",
    ".superin3i4í",
    ".supe3r4i3o",
    ".supé3r4i3o",
    ".supe3r4i3ó",
    ".supe2r1ir",
    ".supe3r4is.",
    ".supé3r4is.",
    ".supe3r4i3u",
    ".supé3r4i3u",
    ".supe4r5i4ume",
    ".supe2r1o2b1d",
    ".supe2r1o2b3r",
    ".supe2r1ó2b3r",
    ".supe2r1o2b1u",
    ".supe2r1o2b1ú",
    ".supe2r1oc",
    ".supe2r1óc",
    ".supe2r1op",
    ".supe3r2or",
    ".supe4r3ord",
    ".supe2r3s2c",
    ".supe2r3s2p",
    ".supe2r5s4t",
    ".supé2r5s4t",
    ".supe2r1sub3s2t",
    ".supe2r3u",
    ".supe2r3ú",
    ".supe3r4um.",
    ".supe3r2us.",
    ".supra3s2c",
    ".su5s4cr",
    ".su3s2pec",
    ".su3s2péc",
    ".su4s3pen",
    ".su4s3pén",
    ".su3s2pic",
    ".su3s2píc",
    ".sú3s2pic",
    ".su3s2pir",
    ".su3s2pír",
    ".t2",
    ".ta2m3",
    ".te2r1i2u",
    ".terp2s",
    ".te2r1un",
    ".te2r1ún",
    ".tetra3e2t",
    ".tetra3g2n",
    ".tetra3s2t",
    ".te2ut",
    ".the2o",
    ".theo3g2n",
    ".the3s2p",
    ".the3s2t",
    ".thi3s2b",
    ".tra1i2a",
    ".tra1i2e",
    ".tra1ii",
    ".tran2s",
    ".trán2s",
    ".transa2",
    ".trans1a2b1e2",
    ".trans1a2b1é2",
    ".trans1a2b1i",
    ".trans1a2b1í",
    ".trans1act",
    ".trans1a2d1",
    ".trans1a2u",
    ".tran3s2c",
    ".trans1e",
    ".tráns1e",
    ".trans3ea",
    ".tráns3ea",
    ".tran3s2en",
    ".transe2u",
    ".tránse2u",
    ".transe2ú",
    ".trans3i",
    ".trans3í",
    ".tráns3i",
    ".trans3íb",
    ".transi3e",
    ".transi3é",
    ".tránsi3e",
    ".tráns3i4i",
    ".tran3s4il",
    ".tran3s4íl",
    ".trans1o2",
    ".trans1u2",
    ".tran3s2um",
    ".tra2n1ue",
    ".tri3en",
    ".uni3an",
    ".uni3án",
    ".u3n2i3uscu",
    ".ute2r3ui",
    ".ve2l1ut",
    ".x2",
    ".z2",
    ".za2i3eu",
    ".zeu3g2m",
    "a1",
    "á1",
    "a1e.",
    "æ1",
    "ǽ1",
    "æ3a",
    "æ3á",
    "ǽ3a",
    "æ3e",
    "æ3é",
    "ǽ3e",
    "æ3i",
    "æ3í",
    "ǽ3i",
    "æ3o",
    "æ3ó",
    "ǽ3o",
    "æ3u",
    "æ3ú",
    "ǽ3u",
    "ai2e",
    "ai2é",
    "ai4i",
    "ai2o",
    "ai2ó",
    "ai6or.",
    "a1is",
    "a1ís",
    "a3it.",
    "á3it.",
    "ai2u",
    "ái2u",
    "ai4unt.",
    "a2m3ui",
    "a2u",
    "a5ú",
    "á2u",
    "a3um.",
    "á3um.",
    "a3us.",
    "á3us.",
    "2ax.",
    "a2y",
    "á2y",
    "1b",
    "2b.",
    "2bb",
    "2bd",
    "2bh",
    "2bj",
    "b2l",
    "2bm",
    "2bn",
    "2bp",
    "b2r",
    "2bs",
    "b3s2t",
    "2bt",
    "bu3is.",
    "bu3u",
    "1c",
    "4c.",
    "2cc",
    "2cd",
    "c2h",
    "2ch.",
    "ch4l",
    "4ch3m",
    "cho3e",
    "ch4r",
    "4ch3t",
    "ci3ent",
    "ci3et",
    "c4l",
    "2cm",
    "2cn",
    "2cq",
    "c6r",
    "2cs",
    "2ct",
    "cu3",
    "cui4ús",
    "cu4lc",
    "cú4lc",
    "cu4ln",
    "cú4ln",
    "cu4lp",
    "cú4lp",
    "cu4mb",
    "cu4nc",
    "cu4nt",
    "cu4rs",
    "2cz",
    "1d",
    "2d.",
    "d2æ.",
    "d2am.",
    "2dc",
    "2dd",
    "2df",
    "2dg",
    "2d3h",
    "d4it.",
    "2dl",
    "2dm",
    "2dn",
    "2dp",
    "2dq",
    "d2r",
    "2ds",
    "du3u",
    "4dv",
    "2d3w",
    "e1",
    "é1",
    "ë1",
    "e3am.",
    "é3am.",
    "e5ant.",
    "é5ant.",
    "e3at.",
    "é3at.",
    "ei2a",
    "ei2á",
    "éi2a",
    "ei2e",
    "ei2é",
    "éi2e",
    "ei4i",
    "ei2í",
    "éi4i",
    "ei4o",
    "éi4o",
    "e3is.",
    "é3is.",
    "ei2u",
    "ei2ú",
    "éi2u",
    "ei4us.",
    "éi4us.",
    "e2l3ue",
    "2em.",
    "2es.",
    "e2s3r",
    "2et.",
    "e5ú",
    "2ex.",
    "e3y",
    "1f",
    "2f.",
    "2ff",
    "f2l",
    "2fn",
    "f2r",
    "2ft",
    "1g",
    "2g.",
    "2gd",
    "ge3n2ua",
    "2gf",
    "2gg",
    "g2l",
    "2gm",
    "g2n",
    "g4ne.",
    "g2r",
    "2gs",
    "1h",
    "2h.",
    "h3m",
    "2hp",
    "2ht",
    "hu2c5us",
    "i1",
    "í1",
    "ï1",
    "í5a",
    "í5æ",
    "í5e",
    "i1el.",
    "i3em.",
    "i3ems.",
    "i3ens.",
    "i3ent.",
    "i3es.",
    "i3et.",
    "í5i",
    "i5i.",
    "i3is.",
    "i5it.",
    "2i2m.",
    "í5o",
    "i2oi2u",
    "i5or.",
    "2i2s.",
    "2i2t.",
    "í5u",
    "i3ud.",
    "i3um.",
    "i3unt.",
    "i3ur.",
    "i3us.",
    "i2u2s3l",
    "i2ú2s3l",
    "i2u2s3v",
    "i2ú2s3v",
    "2i2x.",
    "1j",
    "1k",
    "1l",
    "4l.",
    "langu5i.",
    "langu5it.",
    "langu5imus.",
    "lángu5i.",
    "lángu5it.",
    "lángu5imus.",
    "2lb",
    "2lc",
    "2ld",
    "2lf",
    "l3f2t",
    "2lg",
    "2lk",
    "2ll",
    "2lm",
    "2ln",
    "2lp",
    "2lq",
    "2lr",
    "2ls",
    "4lt",
    "lu3i2a.",
    "lú3i2a.",
    "lu1un",
    "lu1ún",
    "4lv",
    "4lz",
    "1m",
    "4m.",
    "2mb",
    "2mc",
    "me4t3ips",
    "2md",
    "2mf",
    "2ml",
    "2mm",
    "2mn",
    "2mp",
    "4mq",
    "2mr",
    "2ms",
    "2mt",
    "6mv",
    "1n",
    "2n.",
    "2nb",
    "2nc",
    "nco3i",
    "4nd",
    "3ne.",
    "2nf",
    "2ng",
    "ngu6a",
    "ngu2á",
    "ngu2æ",
    "ngu2ǽ",
    "ngu6e",
    "ngu7era",
    "ngu7eri",
    "ngu8eris",
    "ngu8eri.",
    "ngu7ero.",
    "ngu7erunt.",
    "ngu7érunt.",
    "ngu6é",
    "ngu4i",
    "ngu4i3a",
    "ngu5iss",
    "ngu5ist",
    "ngu6isse.",
    "ngu4í",
    "ngu6o",
    "ngu6ó",
    "ngu6u",
    "ngu6ú",
    "ngú7a",
    "ngú7æ",
    "ngú7e",
    "ngú7i",
    "ngú7o",
    "ngú7u",
    "2nh",
    "2nj",
    "2nl",
    "2nm",
    "2nn",
    "2np",
    "2nq",
    "2nr",
    "2ns",
    "n2s3f",
    "n2s3m",
    "2nt",
    "nu3is.",
    "4nv",
    "2nx2",
    "2nz",
    "o1",
    "ó1",
    "œ1",
    "oi2a",
    "ói2a",
    "oi2e",
    "ói2e",
    "oi2o",
    "ói2o",
    "oi2u",
    "ói2u",
    "o3um.",
    "u2s3que",
    "2ox.",
    "o3y",
    "1p",
    "2p.",
    "p2h",
    "2ph.",
    "pha3el",
    "2php",
    "ph3ph",
    "2pht",
    "p2l",
    "2pn",
    "3p2neu",
    "po2t3en",
    "po2t3én",
    "po2t3er",
    "po2t3ér",
    "po2t3es",
    "po2t3és",
    "4pp",
    "p2r",
    "2ps",
    "3p2sic",
    "4p3t",
    "3p2tr",
    "2pz",
    "1qu4",
    "1qui3a",
    "1qui3á",
    "1qui3æ",
    "1qui3ǽ",
    "1qui3e",
    "1qui3é",
    "1qui3o",
    "1qui3ó",
    "1qui5u",
    "1qui5ú",
    "qu6o.",
    "qu6u",
    "qu6um.",
    "1r",
    "4r.",
    "r2æ.",
    "2rb",
    "2rc",
    "r2chm",
    "2rd",
    "2rf",
    "2rg",
    "r2h",
    "ri3e.",
    "r4iit.",
    "2rl",
    "2rm",
    "2rn",
    "2rp",
    "2rq",
    "4r3r",
    "2rs",
    "2rt",
    "ru3is.",
    "ru3it.",
    "r4us.",
    "4rv",
    "2r1x",
    "2rz",
    "1s",
    "4s.",
    "2sb",
    "2sc",
    "3s2cæ",
    "3s2cǽ",
    "3s2ce",
    "3s2cé",
    "3s2ci",
    "3s2cí",
    "3s2cœ",
    "3s2cy",
    "3s2cý",
    "2sd",
    "2s3dem.",
    "2sf",
    "2sg",
    "2sl",
    "2sm",
    "2sn",
    "2sne.",
    "2sp",
    "2sq",
    "2s3que.",
    "2sr",
    "4ss",
    "s3se.",
    "4st",
    "2st.",
    "s4t1k",
    "s2t3l",
    "2s3tn",
    "2st3p",
    "s2t3q",
    "6s5tra.",
    "6s5tri.",
    "6s5tris.",
    "6s5tro.",
    "6s5trorum.",
    "6s5trórum.",
    "6s5trum.",
    "s2t3s",
    "s2t3t",
    "su2b5s4tan",
    "su3is.",
    "2sv",
    "1t",
    "4t.",
    "2tb",
    "2tc",
    "2td",
    "2tf",
    "2tg",
    "t2h4",
    "2th.",
    "th4m",
    "tho3s4t",
    "thó3s4t",
    "2th5p",
    "2th5s",
    "ti3n2ui",
    "ti1o.",
    "2t1íps",
    "t2l",
    "2tm",
    "2tn",
    "2tp",
    "2tq",
    "t4r",
    "tru3um.",
    "tru3us.",
    "2ts",
    "2tt",
    "u1",
    "ú1",
    "ü1",
    "ú5a",
    "u3é",
    "ú5e",
    "u3e.",
    "u3em.",
    "u3en",
    "u3es.",
    "u3et.",
    "ú5i",
    "2ui.",
    "u1i2a",
    "u1i2e",
    "u1i2é",
    "u1i2o",
    "u3is.",
    "u3it.",
    "ui2u",
    "ui4us.",
    "ú5o",
    "u5o.",
    "uo3u",
    "uo3us",
    "uo3ús",
    "ú5u",
    "u5um.",
    "u5us.",
    "2ux.",
    "1v",
    "1x",
    "2x.",
    "x2it.",
    "2xq",
    "2xt",
    "x2u3it.",
    "x2ú3it.",
    "x2um.",
    "x2us.",
    "x2y",
    "xy4s3t",
    "y1",
    "ý1",
    "y3a",
    "y3e",
    "y3i",
    "y3o",
    "y3u",
    "y3æ",
    "y3y",
    "2y.",
    "2ys.",
    "2yx.",
    "1z",
    "2z.",
    "2zz",
    "8́",
    ""
  ];

  return {
    patterns: patterns,
    exceptions: hyphenation
  };
});
