"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Marketplace
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ModuleDataManagementListInstance = exports.ModuleDataManagementInstance = exports.ModuleDataManagementContextImpl = void 0;
const util_1 = require("util");
const deserialize = require("../../../base/deserialize");
const serialize = require("../../../base/serialize");
const utility_1 = require("../../../base/utility");
class ModuleDataManagementContextImpl {
    constructor(_version, sid) {
        this._version = _version;
        if (!(0, utility_1.isValidPathParam)(sid)) {
            throw new Error("Parameter 'sid' is not valid.");
        }
        this._solution = { sid };
        this._uri = `/Listing/${sid}`;
    }
    fetch(callback) {
        const headers = {};
        headers["Accept"] = "application/json";
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.fetch({
            uri: instance._uri,
            method: "get",
            headers,
        });
        operationPromise = operationPromise.then((payload) => new ModuleDataManagementInstance(operationVersion, payload, instance._solution.sid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    update(params, callback) {
        if (params instanceof Function) {
            callback = params;
            params = {};
        }
        else {
            params = params || {};
        }
        let data = {};
        if (params["moduleInfo"] !== undefined)
            data["ModuleInfo"] = params["moduleInfo"];
        if (params["description"] !== undefined)
            data["Description"] = params["description"];
        if (params["documentation"] !== undefined)
            data["Documentation"] = params["documentation"];
        if (params["policies"] !== undefined)
            data["Policies"] = params["policies"];
        if (params["support"] !== undefined)
            data["Support"] = params["support"];
        if (params["configuration"] !== undefined)
            data["Configuration"] = params["configuration"];
        if (params["pricing"] !== undefined)
            data["Pricing"] = params["pricing"];
        const headers = {};
        headers["Content-Type"] = "application/x-www-form-urlencoded";
        headers["Accept"] = "application/json";
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.update({
            uri: instance._uri,
            method: "post",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new ModuleDataManagementInstance(operationVersion, payload, instance._solution.sid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return this._solution;
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.ModuleDataManagementContextImpl = ModuleDataManagementContextImpl;
class ModuleDataManagementInstance {
    constructor(_version, payload, sid) {
        this._version = _version;
        this.url = payload.url;
        this.sid = payload.sid;
        this.description = payload.description;
        this.support = payload.support;
        this.policies = payload.policies;
        this.moduleInfo = payload.module_info;
        this.documentation = payload.documentation;
        this.configuration = payload.configuration;
        this.pricing = payload.pricing;
        this.listings = payload.listings;
        this._solution = { sid: sid || this.sid };
    }
    get _proxy() {
        this._context =
            this._context ||
                new ModuleDataManagementContextImpl(this._version, this._solution.sid);
        return this._context;
    }
    /**
     * Fetch a ModuleDataManagementInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed ModuleDataManagementInstance
     */
    fetch(callback) {
        return this._proxy.fetch(callback);
    }
    update(params, callback) {
        return this._proxy.update(params, callback);
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            url: this.url,
            sid: this.sid,
            description: this.description,
            support: this.support,
            policies: this.policies,
            moduleInfo: this.moduleInfo,
            documentation: this.documentation,
            configuration: this.configuration,
            pricing: this.pricing,
            listings: this.listings,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.ModuleDataManagementInstance = ModuleDataManagementInstance;
function ModuleDataManagementListInstance(version) {
    const instance = ((sid) => instance.get(sid));
    instance.get = function get(sid) {
        return new ModuleDataManagementContextImpl(version, sid);
    };
    instance._version = version;
    instance._solution = {};
    instance._uri = ``;
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
exports.ModuleDataManagementListInstance = ModuleDataManagementListInstance;
