"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Messaging
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.RequestManagedCertListInstance = exports.RequestManagedCertInstance = exports.RequestManagedCertContextImpl = void 0;
const util_1 = require("util");
const deserialize = require("../../../base/deserialize");
const serialize = require("../../../base/serialize");
const utility_1 = require("../../../base/utility");
class RequestManagedCertContextImpl {
    constructor(_version, domainSid) {
        this._version = _version;
        if (!(0, utility_1.isValidPathParam)(domainSid)) {
            throw new Error("Parameter 'domainSid' is not valid.");
        }
        this._solution = { domainSid };
        this._uri = `/LinkShortening/Domains/${domainSid}/RequestManagedCert`;
    }
    update(callback) {
        const headers = {};
        headers["Accept"] = "application/json";
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.update({
            uri: instance._uri,
            method: "post",
            headers,
        });
        operationPromise = operationPromise.then((payload) => new RequestManagedCertInstance(operationVersion, payload, instance._solution.domainSid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return this._solution;
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.RequestManagedCertContextImpl = RequestManagedCertContextImpl;
class RequestManagedCertInstance {
    constructor(_version, payload, domainSid) {
        this._version = _version;
        this.domainSid = payload.domain_sid;
        this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated);
        this.dateCreated = deserialize.iso8601DateTime(payload.date_created);
        this.dateExpires = deserialize.iso8601DateTime(payload.date_expires);
        this.domainName = payload.domain_name;
        this.certificateSid = payload.certificate_sid;
        this.url = payload.url;
        this.managed = payload.managed;
        this.requesting = payload.requesting;
        this._solution = { domainSid: domainSid || this.domainSid };
    }
    get _proxy() {
        this._context =
            this._context ||
                new RequestManagedCertContextImpl(this._version, this._solution.domainSid);
        return this._context;
    }
    /**
     * Update a RequestManagedCertInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed RequestManagedCertInstance
     */
    update(callback) {
        return this._proxy.update(callback);
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            domainSid: this.domainSid,
            dateUpdated: this.dateUpdated,
            dateCreated: this.dateCreated,
            dateExpires: this.dateExpires,
            domainName: this.domainName,
            certificateSid: this.certificateSid,
            url: this.url,
            managed: this.managed,
            requesting: this.requesting,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.RequestManagedCertInstance = RequestManagedCertInstance;
function RequestManagedCertListInstance(version) {
    const instance = ((domainSid) => instance.get(domainSid));
    instance.get = function get(domainSid) {
        return new RequestManagedCertContextImpl(version, domainSid);
    };
    instance._version = version;
    instance._solution = {};
    instance._uri = ``;
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
exports.RequestManagedCertListInstance = RequestManagedCertListInstance;
