"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Numbers
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.BundleCloneListInstance = exports.BundleCloneInstance = exports.BundleCloneContextImpl = void 0;
const util_1 = require("util");
const deserialize = require("../../../base/deserialize");
const serialize = require("../../../base/serialize");
const utility_1 = require("../../../base/utility");
class BundleCloneContextImpl {
    constructor(_version, bundleSid) {
        this._version = _version;
        if (!(0, utility_1.isValidPathParam)(bundleSid)) {
            throw new Error("Parameter 'bundleSid' is not valid.");
        }
        this._solution = { bundleSid };
        this._uri = `/RegulatoryCompliance/Bundles/${bundleSid}/Clones`;
    }
    create(params, callback) {
        if (params === null || params === undefined) {
            throw new Error('Required parameter "params" missing.');
        }
        if (params["targetAccountSid"] === null ||
            params["targetAccountSid"] === undefined) {
            throw new Error("Required parameter \"params['targetAccountSid']\" missing.");
        }
        let data = {};
        data["TargetAccountSid"] = params["targetAccountSid"];
        if (params["moveToDraft"] !== undefined)
            data["MoveToDraft"] = serialize.bool(params["moveToDraft"]);
        if (params["friendlyName"] !== undefined)
            data["FriendlyName"] = params["friendlyName"];
        const headers = {};
        headers["Content-Type"] = "application/x-www-form-urlencoded";
        headers["Accept"] = "application/json";
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.create({
            uri: instance._uri,
            method: "post",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new BundleCloneInstance(operationVersion, payload, instance._solution.bundleSid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return this._solution;
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.BundleCloneContextImpl = BundleCloneContextImpl;
class BundleCloneInstance {
    constructor(_version, payload, bundleSid) {
        this._version = _version;
        this.bundleSid = payload.bundle_sid;
        this.accountSid = payload.account_sid;
        this.regulationSid = payload.regulation_sid;
        this.friendlyName = payload.friendly_name;
        this.status = payload.status;
        this.validUntil = deserialize.iso8601DateTime(payload.valid_until);
        this.email = payload.email;
        this.statusCallback = payload.status_callback;
        this.dateCreated = deserialize.iso8601DateTime(payload.date_created);
        this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated);
        this.url = payload.url;
        this._solution = { bundleSid: bundleSid || this.bundleSid };
    }
    get _proxy() {
        this._context =
            this._context ||
                new BundleCloneContextImpl(this._version, this._solution.bundleSid);
        return this._context;
    }
    create(params, callback) {
        return this._proxy.create(params, callback);
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            bundleSid: this.bundleSid,
            accountSid: this.accountSid,
            regulationSid: this.regulationSid,
            friendlyName: this.friendlyName,
            status: this.status,
            validUntil: this.validUntil,
            email: this.email,
            statusCallback: this.statusCallback,
            dateCreated: this.dateCreated,
            dateUpdated: this.dateUpdated,
            url: this.url,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.BundleCloneInstance = BundleCloneInstance;
function BundleCloneListInstance(version) {
    const instance = ((bundleSid) => instance.get(bundleSid));
    instance.get = function get(bundleSid) {
        return new BundleCloneContextImpl(version, bundleSid);
    };
    instance._version = version;
    instance._solution = {};
    instance._uri = ``;
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
exports.BundleCloneListInstance = BundleCloneListInstance;
