"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Organization Public API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccountPage = exports.AccountListInstance = exports.AccountInstance = exports.AccountContextImpl = void 0;
const util_1 = require("util");
const Page_1 = __importDefault(require("../../../../base/Page"));
const deserialize = require("../../../../base/deserialize");
const serialize = require("../../../../base/serialize");
const utility_1 = require("../../../../base/utility");
class AccountContextImpl {
    constructor(_version, organizationSid, accountSid) {
        this._version = _version;
        if (!(0, utility_1.isValidPathParam)(organizationSid)) {
            throw new Error("Parameter 'organizationSid' is not valid.");
        }
        if (!(0, utility_1.isValidPathParam)(accountSid)) {
            throw new Error("Parameter 'accountSid' is not valid.");
        }
        this._solution = { organizationSid, accountSid };
        this._uri = `/${organizationSid}/Accounts/${accountSid}`;
    }
    fetch(callback) {
        const headers = {};
        headers["Accept"] = "application/json";
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.fetch({
            uri: instance._uri,
            method: "get",
            headers,
        });
        operationPromise = operationPromise.then((payload) => new AccountInstance(operationVersion, payload, instance._solution.organizationSid, instance._solution.accountSid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return this._solution;
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.AccountContextImpl = AccountContextImpl;
/**
 * Page content
 */
class AccountInstance {
    constructor(_version, payload, organizationSid, accountSid) {
        this._version = _version;
        this.accountSid = payload.account_sid;
        this.friendlyName = payload.friendly_name;
        this.status = payload.status;
        this.ownerSid = payload.owner_sid;
        this.dateCreated = deserialize.iso8601DateTime(payload.date_created);
        this._solution = {
            organizationSid,
            accountSid: accountSid || this.accountSid,
        };
    }
    get _proxy() {
        this._context =
            this._context ||
                new AccountContextImpl(this._version, this._solution.organizationSid, this._solution.accountSid);
        return this._context;
    }
    /**
     * Fetch a AccountInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed AccountInstance
     */
    fetch(callback) {
        return this._proxy.fetch(callback);
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            accountSid: this.accountSid,
            friendlyName: this.friendlyName,
            status: this.status,
            ownerSid: this.ownerSid,
            dateCreated: this.dateCreated,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.AccountInstance = AccountInstance;
function AccountListInstance(version, organizationSid) {
    if (!(0, utility_1.isValidPathParam)(organizationSid)) {
        throw new Error("Parameter 'organizationSid' is not valid.");
    }
    const instance = ((accountSid) => instance.get(accountSid));
    instance.get = function get(accountSid) {
        return new AccountContextImpl(version, organizationSid, accountSid);
    };
    instance._version = version;
    instance._solution = { organizationSid };
    instance._uri = `/${organizationSid}/Accounts`;
    instance.page = function page(params, callback) {
        if (params instanceof Function) {
            callback = params;
            params = {};
        }
        else {
            params = params || {};
        }
        let data = {};
        if (params["pageSize"] !== undefined)
            data["PageSize"] = params["pageSize"];
        if (params.pageNumber !== undefined)
            data["Page"] = params.pageNumber;
        if (params.pageToken !== undefined)
            data["PageToken"] = params.pageToken;
        const headers = {};
        headers["Accept"] = "application/json";
        let operationVersion = version, operationPromise = operationVersion.page({
            uri: instance._uri,
            method: "get",
            params: data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new AccountPage(operationVersion, payload, instance._solution));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    };
    instance.each = instance._version.each;
    instance.list = instance._version.list;
    instance.getPage = function getPage(targetUrl, callback) {
        const operationPromise = instance._version._domain.twilio.request({
            method: "get",
            uri: targetUrl,
        });
        let pagePromise = operationPromise.then((payload) => new AccountPage(instance._version, payload, instance._solution));
        pagePromise = instance._version.setPromiseCallback(pagePromise, callback);
        return pagePromise;
    };
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
exports.AccountListInstance = AccountListInstance;
class AccountPage extends Page_1.default {
    /**
     * Initialize the AccountPage
     *
     * @param version - Version of the resource
     * @param response - Response from the API
     * @param solution - Path solution
     */
    constructor(version, response, solution) {
        super(version, response, solution);
    }
    /**
     * Build an instance of AccountInstance
     *
     * @param payload - Payload response from the API
     */
    getInstance(payload) {
        return new AccountInstance(this._version, payload, this._solution.organizationSid);
    }
    [util_1.inspect.custom](depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.AccountPage = AccountPage;
