"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypeFactory = void 0;
const typescript_1 = __importDefault(require("typescript"));
var TypeFactory;
(function (TypeFactory) {
    TypeFactory.isFunction = (type) => TypeFactory.getFunction(type) !== null;
    TypeFactory.getFunction = (type) => {
        var _a, _b;
        const node = (_b = (_a = type.symbol) === null || _a === void 0 ? void 0 : _a.declarations) === null || _b === void 0 ? void 0 : _b[0];
        if (node === undefined)
            return null;
        return typescript_1.default.isFunctionLike(node)
            ? node
            : typescript_1.default.isPropertyAssignment(node) || typescript_1.default.isPropertyDeclaration(node)
                ? typescript_1.default.isFunctionLike(node.initializer)
                    ? node.initializer
                    : null
                : null;
    };
    TypeFactory.getReturnTypeOfClassMethod = (props) => {
        // FIND TO-JSON METHOD
        const symbol = props.class.getProperty(props.function);
        if (!symbol)
            return null;
        else if (!symbol.valueDeclaration)
            return null;
        // GET FUNCTION DECLARATION
        const functor = props.checker.getTypeOfSymbolAtLocation(symbol, symbol.valueDeclaration);
        // RETURNS THE RETURN-TYPE
        const signature = props.checker.getSignaturesOfType(functor, typescript_1.default.SignatureKind.Call)[0];
        return signature ? signature.getReturnType() : null;
    };
    TypeFactory.getFullName = (props) => {
        var _a, _b, _c;
        // PRIMITIVE
        const symbol = (_b = (_a = props.symbol) !== null && _a !== void 0 ? _a : props.type.aliasSymbol) !== null && _b !== void 0 ? _b : props.type.getSymbol();
        if (symbol === undefined)
            return props.checker.typeToString(props.type);
        // UNION OR INTERSECT
        if (props.type.aliasSymbol === undefined &&
            props.type.isUnionOrIntersection()) {
            const joiner = props.type.isIntersection() ? " & " : " | ";
            return props.type.types
                .map((child) => TypeFactory.getFullName({
                checker: props.checker,
                type: child,
            }))
                .join(joiner);
        }
        //----
        // SPECIALIZATION
        //----
        const name = get_name(symbol);
        // CHECK GENERIC
        const generic = props.type.aliasSymbol && props.aliasTypeArguments !== false
            ? ((_c = props.type.aliasTypeArguments) !== null && _c !== void 0 ? _c : [])
            : props.checker.getTypeArguments(props.type);
        return generic.length
            ? name === "Promise"
                ? TypeFactory.getFullName({
                    checker: props.checker,
                    type: generic[0],
                })
                : `${name}<${generic
                    .map((child) => TypeFactory.getFullName({
                    checker: props.checker,
                    type: child,
                }))
                    .join(", ")}>`
            : name;
    };
    const explore_name = (props) => typescript_1.default.isModuleBlock(props.node)
        ? explore_name({
            node: props.node.parent.parent,
            name: `${props.node.parent.name.getFullText().trim()}.${props.name}`,
        })
        : props.name;
    const get_name = (symbol) => {
        var _a, _b;
        const parent = (_b = (_a = symbol.getDeclarations()) === null || _a === void 0 ? void 0 : _a[0]) === null || _b === void 0 ? void 0 : _b.parent;
        return parent
            ? explore_name({
                node: parent,
                name: symbol.escapedName.toString(),
            })
            : "__type";
    };
    TypeFactory.keyword = (type) => {
        return typescript_1.default.factory.createKeywordTypeNode(type === "void"
            ? typescript_1.default.SyntaxKind.VoidKeyword
            : type === "any"
                ? typescript_1.default.SyntaxKind.AnyKeyword
                : type === "unknown"
                    ? typescript_1.default.SyntaxKind.UnknownKeyword
                    : type === "boolean"
                        ? typescript_1.default.SyntaxKind.BooleanKeyword
                        : type === "number"
                            ? typescript_1.default.SyntaxKind.NumberKeyword
                            : type === "bigint"
                                ? typescript_1.default.SyntaxKind.BigIntKeyword
                                : typescript_1.default.SyntaxKind.StringKeyword);
    };
})(TypeFactory || (exports.TypeFactory = TypeFactory = {}));
//# sourceMappingURL=TypeFactory.js.map