import { MetadataSet } from '../../../schemas/metadata/MetadataSet.mjs';
import { ArrayUtil } from '../../../utils/ArrayUtil.mjs';
import { TypeFactory } from '../../TypeFactory.mjs';
import { explore_metadata } from './explore_metadata.mjs';

const iterate_metadata_set = (props) => {
    const type = props.checker.getApparentType(props.type);
    const name = TypeFactory.getFullName({
        checker: props.checker,
        type: type,
        symbol: type.getSymbol(),
        aliasTypeArguments: false,
    });
    const generic = props.checker.getTypeArguments(type);
    if (name.substring(0, 4) !== "Set<" || generic?.length !== 1)
        return false;
    const key = generic[0];
    const value = explore_metadata({
        ...props,
        type: key,
        explore: {
            ...props.explore,
            escaped: false,
            aliased: false,
        },
        intersected: false,
    });
    ArrayUtil.take(props.metadata.sets, (elem) => elem.value.getName() === value.getName(), () => MetadataSet.create({
        value: explore_metadata({
            ...props,
            type: key,
            explore: {
                ...props.explore,
                escaped: false,
                aliased: false,
            },
            intersected: false,
        }),
        tags: [],
    }));
    return true;
};

export { iterate_metadata_set };
//# sourceMappingURL=iterate_metadata_set.mjs.map
