"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.check_array_length = void 0;
const ExpressionFactory_1 = require("../../factories/ExpressionFactory");
/** @internal */
const check_array_length = (props) => {
    const conditions = check_array_type_tags(props);
    return {
        expected: props.array.getName(),
        expression: null,
        conditions,
    };
};
exports.check_array_length = check_array_length;
/** @internal */
const check_array_type_tags = (props) => props.array.tags
    .map((row) => row.filter((tag) => !!tag.validate))
    .filter((row) => !!row.length)
    .map((row) => row.map((tag) => ({
    expected: `Array<> & ${tag.name}`,
    expression: ExpressionFactory_1.ExpressionFactory.transpile({
        transformer: props.context.transformer,
        importer: props.context.importer,
        script: tag.validate,
    })(props.input),
})));
//# sourceMappingURL=check_array_length.js.map