import ts from 'typescript';
import { ExpressionFactory } from '../../factories/ExpressionFactory.mjs';

/** @internal */
const check_bigint = (props) => {
    const conditions = check_bigint_type_tags(props);
    return {
        expected: props.atomic.getName(),
        expression: ts.factory.createStrictEquality(ts.factory.createStringLiteral("bigint"), ts.factory.createTypeOfExpression(props.input)),
        conditions,
    };
};
/** @internal */
const check_bigint_type_tags = (props) => props.atomic.tags
    .map((row) => row.filter((tag) => !!tag.validate))
    .filter((row) => !!row.length)
    .map((row) => row.map((tag) => ({
    expected: `bigint & ${tag.name}`,
    expression: ExpressionFactory.transpile({
        transformer: props.context.transformer,
        importer: props.context.importer,
        script: tag.validate,
    })(props.input),
})));

export { check_bigint };
//# sourceMappingURL=check_bigint.mjs.map
