import ts from 'typescript';
import { check_dynamic_properties } from './check_dynamic_properties.mjs';
import { check_everything } from './check_everything.mjs';

/** @internal */
const check_object = (props) => {
    // PREPARE ASSETS
    const regular = props.entries.filter((entry) => entry.key.isSoleLiteral());
    const dynamic = props.entries.filter((entry) => !entry.key.isSoleLiteral());
    const flags = regular.map((entry) => entry.expression);
    // REGULAR WITHOUT DYNAMIC PROPERTIES
    if (props.config.equals === false && dynamic.length === 0)
        return regular.length === 0
            ? props.config.positive
            : reduce({
                config: props.config,
                expressions: flags,
            });
    // CHECK DYNAMIC PROPERTIES
    flags.push(check_dynamic_properties({
        config: props.config,
        context: props.context,
        input: props.input,
        regular,
        dynamic,
    }));
    return reduce({
        config: props.config,
        expressions: flags,
    });
};
/** @internal */
const reduce = (props) => props.config.assert
    ? props.expressions.reduce(props.config.reduce)
    : check_everything(ts.factory.createArrayLiteralExpression(props.expressions));

export { check_object };
//# sourceMappingURL=check_object.mjs.map
