"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.json_schema_escaped = void 0;
const openapi_1 = require("@samchon/openapi");
const json_schema_station_1 = require("./json_schema_station");
/** @internal */
const json_schema_escaped = (props) => {
    const output = (0, json_schema_station_1.json_schema_station)({
        blockNever: false,
        components: props.components,
        metadata: props.escaped.returns,
        attribute: {},
    });
    if (output === null)
        return [];
    if (is_date({
        visited: new Set(),
        metadata: props.escaped.original,
    })) {
        const string = openapi_1.OpenApiTypeChecker.isString(output)
            ? output
            : openapi_1.OpenApiTypeChecker.isOneOf(output)
                ? output.oneOf.find(openapi_1.OpenApiTypeChecker.isString)
                : undefined;
        if (string !== undefined &&
            string.format !== "date" &&
            string.format !== "date-time")
            string.format = "date-time";
    }
    return openapi_1.OpenApiTypeChecker.isOneOf(output)
        ? output.oneOf
        : [output];
};
exports.json_schema_escaped = json_schema_escaped;
/** @internal */
const is_date = (props) => {
    if (props.visited.has(props.metadata))
        return false;
    props.visited.add(props.metadata);
    return (props.metadata.natives.some((native) => native.name === "Date") ||
        props.metadata.arrays.some((array) => is_date({
            visited: props.visited,
            metadata: array.type.value,
        })) ||
        props.metadata.tuples.some((tuple) => tuple.type.elements.some((e) => is_date({
            visited: props.visited,
            metadata: e,
        }))) ||
        props.metadata.aliases.some((alias) => is_date({
            visited: props.visited,
            metadata: alias.type.value,
        })));
};
//# sourceMappingURL=json_schema_escaped.js.map