"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.json_schema_object = void 0;
const CommentFactory_1 = require("../../factories/CommentFactory");
const Metadata_1 = require("../../schemas/metadata/Metadata");
const PatternUtil_1 = require("../../utils/PatternUtil");
const json_schema_description_1 = require("./json_schema_description");
const json_schema_plugin_1 = require("./json_schema_plugin");
const json_schema_station_1 = require("./json_schema_station");
const json_schema_title_1 = require("./json_schema_title");
const metadata_to_pattern_1 = require("./metadata_to_pattern");
/** @internal */
const json_schema_object = (props) => (0, json_schema_plugin_1.json_schema_plugin)({
    schema: emplace_object(props),
    tags: props.object.tags,
});
exports.json_schema_object = json_schema_object;
const emplace_object = (props) => {
    var _a, _b;
    var _c;
    if (props.object.type.isLiteral() === true)
        return create_object_schema(props);
    const key = props.object.type.name;
    const $ref = `#/components/schemas/${key}`;
    if (((_a = props.components.schemas) === null || _a === void 0 ? void 0 : _a[key]) !== undefined)
        return { $ref };
    const lazy = {};
    (_b = (_c = props.components).schemas) !== null && _b !== void 0 ? _b : (_c.schemas = {});
    props.components.schemas[key] = lazy;
    Object.assign(lazy, create_object_schema(props));
    return { $ref };
};
/** @internal */
const create_object_schema = (props) => {
    // ITERATE PROPERTIES
    const properties = {};
    const extraMeta = {
        patternProperties: {},
        additionalProperties: undefined,
    };
    const required = [];
    for (const property of props.object.type.properties) {
        if (
        // FUNCTIONAL TYPE
        property.value.functions.length &&
            property.value.nullable === false &&
            property.value.isRequired() === true &&
            property.value.size() === 0)
            continue;
        else if (property.jsDocTags.find((tag) => tag.name === "hidden"))
            continue; // THE HIDDEN TAG
        const key = property.key.getSoleLiteral();
        const schema = (0, json_schema_station_1.json_schema_station)({
            blockNever: true,
            components: props.components,
            attribute: {
                deprecated: property.jsDocTags.some((tag) => tag.name === "deprecated") ||
                    undefined,
                title: (0, json_schema_title_1.json_schema_title)(property),
                description: (0, json_schema_description_1.json_schema_description)(property),
            },
            metadata: property.value,
        });
        if (schema === null)
            continue;
        if (key !== null) {
            properties[key] = schema;
            if (property.value.isRequired() === true)
                required.push(key);
        }
        else {
            const pattern = (0, metadata_to_pattern_1.metadata_to_pattern)({
                top: true,
                metadata: property.key,
            });
            if (pattern === PatternUtil_1.PatternUtil.STRING)
                extraMeta.additionalProperties = [property.value, schema];
            else
                extraMeta.patternProperties[pattern] = [property.value, schema];
        }
    }
    return {
        type: "object",
        properties,
        required,
        title: (() => {
            var _a;
            const info = props.object.type.jsDocTags.find((tag) => tag.name === "title");
            return ((_a = info === null || info === void 0 ? void 0 : info.text) === null || _a === void 0 ? void 0 : _a.length) ? CommentFactory_1.CommentFactory.merge(info.text) : undefined;
        })(),
        description: (0, json_schema_description_1.json_schema_description)(props.object.type),
        additionalProperties: join({
            components: props.components,
            extra: extraMeta,
        }),
    };
};
/** @internal */
const join = (props) => {
    var _a;
    // LIST UP METADATA
    const elements = Object.values(props.extra.patternProperties || {});
    if (props.extra.additionalProperties)
        elements.push(props.extra.additionalProperties);
    // SHORT RETURN
    if (elements.length === 0)
        return undefined;
    else if (elements.length === 1)
        return elements[0][1];
    // MERGE METADATA AND GENERATE VULNERABLE SCHEMA
    const metadata = elements
        .map((tuple) => tuple[0])
        .reduce((x, y) => Metadata_1.Metadata.merge(x, y));
    return ((_a = (0, json_schema_station_1.json_schema_station)({
        blockNever: true,
        components: props.components,
        attribute: {},
        metadata,
    })) !== null && _a !== void 0 ? _a : undefined);
};
//# sourceMappingURL=json_schema_object.js.map