"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata_to_pattern = void 0;
const PatternUtil_1 = require("../../utils/PatternUtil");
const template_to_pattern_1 = require("./template_to_pattern");
/** @internal */
const metadata_to_pattern = (props) => {
    if (props.metadata.atomics.find((a) => a.type === "string") !== undefined)
        return "(.*)";
    const values = props.metadata.constants
        .map((c) => {
        if (c.type !== "string")
            return c.values.map((v) => v.toString());
        return c.values.map((v) => v.value).map((str) => PatternUtil_1.PatternUtil.escape(str));
    })
        .flat();
    for (const a of props.metadata.atomics)
        if (a.type === "number" || a.type === "bigint")
            values.push(PatternUtil_1.PatternUtil.NUMBER);
        else if (a.type === "boolean")
            values.push(PatternUtil_1.PatternUtil.BOOLEAN);
    for (const { row } of props.metadata.templates)
        values.push("(" +
            (0, template_to_pattern_1.template_to_pattern)({
                top: false,
                template: row,
            }) +
            ")");
    const pattern = values.length === 1 ? values[0] : "(" + values.join("|") + ")";
    return props.top ? PatternUtil_1.PatternUtil.fix(pattern) : pattern;
};
exports.metadata_to_pattern = metadata_to_pattern;
//# sourceMappingURL=metadata_to_pattern.js.map