"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsonIsStringifyProgrammer = void 0;
const typescript_1 = __importDefault(require("typescript"));
const IdentifierFactory_1 = require("../../factories/IdentifierFactory");
const StatementFactory_1 = require("../../factories/StatementFactory");
const TypeFactory_1 = require("../../factories/TypeFactory");
const FeatureProgrammer_1 = require("../FeatureProgrammer");
const IsProgrammer_1 = require("../IsProgrammer");
const FunctionProgrammer_1 = require("../helpers/FunctionProgrammer");
const JsonStringifyProgrammer_1 = require("./JsonStringifyProgrammer");
var JsonIsStringifyProgrammer;
(function (JsonIsStringifyProgrammer) {
    JsonIsStringifyProgrammer.decompose = (props) => {
        var _a;
        const is = IsProgrammer_1.IsProgrammer.decompose(Object.assign(Object.assign({}, props), { context: Object.assign(Object.assign({}, props.context), { options: Object.assign(Object.assign({}, props.context.options), { functional: false, numeric: true }) }), config: {
                equals: false,
            } }));
        const stringify = JsonStringifyProgrammer_1.JsonStringifyProgrammer.decompose(Object.assign(Object.assign({}, props), { context: Object.assign(Object.assign({}, props.context), { options: Object.assign(Object.assign({}, props.context.options), { functional: false, numeric: true }) }), validated: true }));
        return {
            functions: Object.assign(Object.assign({}, is.functions), stringify.functions),
            statements: [
                ...is.statements,
                ...stringify.statements,
                StatementFactory_1.StatementFactory.constant({
                    name: "__is",
                    value: is.arrow,
                }),
                StatementFactory_1.StatementFactory.constant({
                    name: "__stringify",
                    value: stringify.arrow,
                }),
            ],
            arrow: typescript_1.default.factory.createArrowFunction(undefined, undefined, [IdentifierFactory_1.IdentifierFactory.parameter("input", TypeFactory_1.TypeFactory.keyword("any"))], typescript_1.default.factory.createUnionTypeNode([
                (_a = stringify.arrow.type) !== null && _a !== void 0 ? _a : TypeFactory_1.TypeFactory.keyword("string"),
                typescript_1.default.factory.createLiteralTypeNode(typescript_1.default.factory.createNull()),
            ]), undefined, typescript_1.default.factory.createConditionalExpression(typescript_1.default.factory.createCallExpression(typescript_1.default.factory.createIdentifier("__is"), undefined, [typescript_1.default.factory.createIdentifier("input")]), undefined, typescript_1.default.factory.createCallExpression(typescript_1.default.factory.createIdentifier("__stringify"), undefined, [typescript_1.default.factory.createIdentifier("input")]), undefined, typescript_1.default.factory.createNull())),
        };
    };
    JsonIsStringifyProgrammer.write = (props) => {
        const functor = new FunctionProgrammer_1.FunctionProgrammer(props.modulo.getText());
        const result = JsonIsStringifyProgrammer.decompose(Object.assign(Object.assign({}, props), { functor }));
        return FeatureProgrammer_1.FeatureProgrammer.writeDecomposed({
            modulo: props.modulo,
            functor,
            result,
        });
    };
})(JsonIsStringifyProgrammer || (exports.JsonIsStringifyProgrammer = JsonIsStringifyProgrammer = {}));
//# sourceMappingURL=JsonIsStringifyProgrammer.js.map