"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsonValidateStringifyProgrammer = void 0;
const typescript_1 = __importDefault(require("typescript"));
const IdentifierFactory_1 = require("../../factories/IdentifierFactory");
const StatementFactory_1 = require("../../factories/StatementFactory");
const TypeFactory_1 = require("../../factories/TypeFactory");
const FeatureProgrammer_1 = require("../FeatureProgrammer");
const ValidateProgrammer_1 = require("../ValidateProgrammer");
const FunctionProgrammer_1 = require("../helpers/FunctionProgrammer");
const JsonStringifyProgrammer_1 = require("./JsonStringifyProgrammer");
var JsonValidateStringifyProgrammer;
(function (JsonValidateStringifyProgrammer) {
    JsonValidateStringifyProgrammer.decompose = (props) => {
        var _a;
        const validate = ValidateProgrammer_1.ValidateProgrammer.decompose(Object.assign(Object.assign({}, props), { context: Object.assign(Object.assign({}, props.context), { options: Object.assign(Object.assign({}, props.context.options), { functional: false, numeric: true }) }), config: {
                equals: false,
            } }));
        const stringify = JsonStringifyProgrammer_1.JsonStringifyProgrammer.decompose(Object.assign(Object.assign({}, props), { validated: true }));
        return {
            functions: Object.assign(Object.assign({}, validate.functions), stringify.functions),
            statements: [
                ...validate.statements,
                ...stringify.statements,
                StatementFactory_1.StatementFactory.constant({
                    name: "__validate",
                    value: validate.arrow,
                }),
                StatementFactory_1.StatementFactory.constant({
                    name: "__stringify",
                    value: stringify.arrow,
                }),
            ],
            arrow: typescript_1.default.factory.createArrowFunction(undefined, undefined, [IdentifierFactory_1.IdentifierFactory.parameter("input", TypeFactory_1.TypeFactory.keyword("any"))], props.context.importer.type({
                file: "typia",
                name: "IValidation",
                arguments: [
                    (_a = stringify.arrow.type) !== null && _a !== void 0 ? _a : typescript_1.default.factory.createTypeReferenceNode("string"),
                ],
            }), undefined, typescript_1.default.factory.createBlock([
                StatementFactory_1.StatementFactory.constant({
                    name: "result",
                    value: typescript_1.default.factory.createAsExpression(typescript_1.default.factory.createCallExpression(typescript_1.default.factory.createIdentifier("__validate"), undefined, [typescript_1.default.factory.createIdentifier("input")]), TypeFactory_1.TypeFactory.keyword("any")),
                }),
                typescript_1.default.factory.createIfStatement(typescript_1.default.factory.createIdentifier("result.success"), typescript_1.default.factory.createExpressionStatement(typescript_1.default.factory.createBinaryExpression(typescript_1.default.factory.createIdentifier("result.data"), typescript_1.default.SyntaxKind.EqualsToken, typescript_1.default.factory.createCallExpression(typescript_1.default.factory.createIdentifier("__stringify"), undefined, [typescript_1.default.factory.createIdentifier("input")])))),
                typescript_1.default.factory.createReturnStatement(typescript_1.default.factory.createIdentifier("result")),
            ])),
        };
    };
    JsonValidateStringifyProgrammer.write = (props) => {
        const functor = new FunctionProgrammer_1.FunctionProgrammer(props.modulo.getText());
        const result = JsonValidateStringifyProgrammer.decompose({
            context: props.context,
            modulo: props.modulo,
            functor,
            type: props.type,
            name: props.name,
        });
        return FeatureProgrammer_1.FeatureProgrammer.writeDecomposed({
            modulo: props.modulo,
            functor,
            result,
        });
    };
})(JsonValidateStringifyProgrammer || (exports.JsonValidateStringifyProgrammer = JsonValidateStringifyProgrammer = {}));
//# sourceMappingURL=JsonValidateStringifyProgrammer.js.map