import { ILlmSchema } from "@samchon/openapi";
import { Metadata } from "../../schemas/metadata/Metadata";
export declare namespace LlmSchemaProgrammer {
    interface IOutput<Model extends ILlmSchema.Model> {
        model: Model;
        schema: ILlmSchema.ModelSchema[Model];
        $defs: Record<string, ILlmSchema.ModelSchema[Model]>;
    }
    const write: <Model extends ILlmSchema.Model>(props: {
        model: Model;
        metadata: Metadata;
        config?: Partial<ILlmSchema.ModelConfig[Model]>;
    }) => IOutput<Model>;
    const validate: <Model extends ILlmSchema.Model>(props: {
        model: ILlmSchema.Model;
        config?: Partial<ILlmSchema.ModelConfig[Model]>;
    }) => (metadata: Metadata) => string[];
}
