"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProtobufIsEncodeProgrammer = void 0;
const typescript_1 = __importDefault(require("typescript"));
const IdentifierFactory_1 = require("../../factories/IdentifierFactory");
const StatementFactory_1 = require("../../factories/StatementFactory");
const TypeFactory_1 = require("../../factories/TypeFactory");
const FeatureProgrammer_1 = require("../FeatureProgrammer");
const IsProgrammer_1 = require("../IsProgrammer");
const FunctionProgrammer_1 = require("../helpers/FunctionProgrammer");
const ProtobufEncodeProgrammer_1 = require("./ProtobufEncodeProgrammer");
var ProtobufIsEncodeProgrammer;
(function (ProtobufIsEncodeProgrammer) {
    ProtobufIsEncodeProgrammer.decompose = (props) => {
        var _a;
        const is = IsProgrammer_1.IsProgrammer.decompose(Object.assign(Object.assign({}, props), { context: Object.assign(Object.assign({}, props.context), { options: Object.assign(Object.assign({}, props.context.options), { functional: false, numeric: true }) }), config: {
                equals: false,
            } }));
        const encode = ProtobufEncodeProgrammer_1.ProtobufEncodeProgrammer.decompose(props);
        return {
            functions: Object.assign(Object.assign({}, is.functions), encode.functions),
            statements: [
                ...is.statements,
                ...encode.statements,
                StatementFactory_1.StatementFactory.constant({
                    name: "__is",
                    value: is.arrow,
                }),
                StatementFactory_1.StatementFactory.constant({
                    name: "__encode",
                    value: encode.arrow,
                }),
            ],
            arrow: typescript_1.default.factory.createArrowFunction(undefined, undefined, [IdentifierFactory_1.IdentifierFactory.parameter("input", TypeFactory_1.TypeFactory.keyword("any"))], typescript_1.default.factory.createUnionTypeNode([
                (_a = encode.arrow.type) !== null && _a !== void 0 ? _a : typescript_1.default.factory.createTypeReferenceNode("Uint8Array"),
                typescript_1.default.factory.createTypeReferenceNode("null"),
            ]), undefined, typescript_1.default.factory.createConditionalExpression(typescript_1.default.factory.createCallExpression(typescript_1.default.factory.createIdentifier("__is"), undefined, [typescript_1.default.factory.createIdentifier("input")]), undefined, typescript_1.default.factory.createCallExpression(typescript_1.default.factory.createIdentifier("__encode"), undefined, [typescript_1.default.factory.createIdentifier("input")]), undefined, typescript_1.default.factory.createNull())),
        };
    };
    ProtobufIsEncodeProgrammer.write = (props) => {
        const functor = new FunctionProgrammer_1.FunctionProgrammer(props.modulo.getText());
        const result = ProtobufIsEncodeProgrammer.decompose(Object.assign(Object.assign({}, props), { functor }));
        return FeatureProgrammer_1.FeatureProgrammer.writeDecomposed({
            modulo: props.modulo,
            functor,
            result,
        });
    };
})(ProtobufIsEncodeProgrammer || (exports.ProtobufIsEncodeProgrammer = ProtobufIsEncodeProgrammer = {}));
//# sourceMappingURL=ProtobufIsEncodeProgrammer.js.map