import ts from 'typescript';
import { IdentifierFactory } from '../../factories/IdentifierFactory.mjs';
import { StatementFactory } from '../../factories/StatementFactory.mjs';
import { TypeFactory } from '../../factories/TypeFactory.mjs';
import { FeatureProgrammer } from '../FeatureProgrammer.mjs';
import { IsProgrammer } from '../IsProgrammer.mjs';
import { FunctionProgrammer } from '../helpers/FunctionProgrammer.mjs';
import { ProtobufEncodeProgrammer } from './ProtobufEncodeProgrammer.mjs';

var ProtobufIsEncodeProgrammer;
(function (ProtobufIsEncodeProgrammer) {
    ProtobufIsEncodeProgrammer.decompose = (props) => {
        const is = IsProgrammer.decompose({
            ...props,
            context: {
                ...props.context,
                options: {
                    ...props.context.options,
                    functional: false,
                    numeric: true,
                },
            },
            config: {
                equals: false,
            },
        });
        const encode = ProtobufEncodeProgrammer.decompose(props);
        return {
            functions: {
                ...is.functions,
                ...encode.functions,
            },
            statements: [
                ...is.statements,
                ...encode.statements,
                StatementFactory.constant({
                    name: "__is",
                    value: is.arrow,
                }),
                StatementFactory.constant({
                    name: "__encode",
                    value: encode.arrow,
                }),
            ],
            arrow: ts.factory.createArrowFunction(undefined, undefined, [IdentifierFactory.parameter("input", TypeFactory.keyword("any"))], ts.factory.createUnionTypeNode([
                encode.arrow.type ?? ts.factory.createTypeReferenceNode("Uint8Array"),
                ts.factory.createTypeReferenceNode("null"),
            ]), undefined, ts.factory.createConditionalExpression(ts.factory.createCallExpression(ts.factory.createIdentifier("__is"), undefined, [ts.factory.createIdentifier("input")]), undefined, ts.factory.createCallExpression(ts.factory.createIdentifier("__encode"), undefined, [ts.factory.createIdentifier("input")]), undefined, ts.factory.createNull())),
        };
    };
    ProtobufIsEncodeProgrammer.write = (props) => {
        const functor = new FunctionProgrammer(props.modulo.getText());
        const result = ProtobufIsEncodeProgrammer.decompose({
            ...props,
            functor,
        });
        return FeatureProgrammer.writeDecomposed({
            modulo: props.modulo,
            functor,
            result,
        });
    };
})(ProtobufIsEncodeProgrammer || (ProtobufIsEncodeProgrammer = {}));

export { ProtobufIsEncodeProgrammer };
//# sourceMappingURL=ProtobufIsEncodeProgrammer.mjs.map
