"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetadataTemplate = void 0;
const Metadata_1 = require("./Metadata");
class MetadataTemplate {
    constructor(props) {
        this.row = props.row.map(Metadata_1.Metadata.create);
        this.tags = props.tags;
    }
    static create(props) {
        return new MetadataTemplate(props);
    }
    static from(json, dict) {
        return new MetadataTemplate({
            row: json.row.map((m) => Metadata_1.Metadata.from(m, dict)),
            tags: json.tags,
        });
    }
    getName() {
        var _a;
        return ((_a = this.name_) !== null && _a !== void 0 ? _a : (this.name_ = getName(this)));
    }
    /** @internal */
    getBaseName() {
        return ("`" +
            this.row
                .map((child) => child.isConstant() && child.size() === 1
                ? child.constants[0].values[0].value
                : `$\{${child.getName()}\}`)
                .join("")
                .split("`")
                .join("\\`") +
            "`");
    }
    toJSON() {
        return {
            row: this.row.map((m) => m.toJSON()),
            tags: this.tags,
        };
    }
}
exports.MetadataTemplate = MetadataTemplate;
const getName = (template) => {
    var _a;
    const base = template.getBaseName();
    if (!((_a = template.tags) === null || _a === void 0 ? void 0 : _a.length))
        return base;
    else if (template.tags.length === 1) {
        const str = [base, ...template.tags[0].map((t) => t.name)].join(" & ");
        return `(${str})`;
    }
    const rows = template.tags.map((row) => {
        const str = row.map((t) => t.name).join(" & ");
        return row.length === 1 ? str : `(${str})`;
    });
    return `(${base} & (${rows.join(" | ")}))`;
};
//# sourceMappingURL=MetadataTemplate.js.map