import { Metadata } from './Metadata.mjs';

class MetadataTemplate {
    row;
    tags;
    name_;
    constructor(props) {
        this.row = props.row.map(Metadata.create);
        this.tags = props.tags;
    }
    static create(props) {
        return new MetadataTemplate(props);
    }
    static from(json, dict) {
        return new MetadataTemplate({
            row: json.row.map((m) => Metadata.from(m, dict)),
            tags: json.tags,
        });
    }
    getName() {
        return (this.name_ ??= getName(this));
    }
    /** @internal */
    getBaseName() {
        return ("`" +
            this.row
                .map((child) => child.isConstant() && child.size() === 1
                ? child.constants[0].values[0].value
                : `$\{${child.getName()}\}`)
                .join("")
                .split("`")
                .join("\\`") +
            "`");
    }
    toJSON() {
        return {
            row: this.row.map((m) => m.toJSON()),
            tags: this.tags,
        };
    }
}
const getName = (template) => {
    const base = template.getBaseName();
    if (!template.tags?.length)
        return base;
    else if (template.tags.length === 1) {
        const str = [base, ...template.tags[0].map((t) => t.name)].join(" & ");
        return `(${str})`;
    }
    const rows = template.tags.map((row) => {
        const str = row.map((t) => t.name).join(" & ");
        return row.length === 1 ? str : `(${str})`;
    });
    return `(${base} & (${rows.join(" | ")}))`;
};

export { MetadataTemplate };
//# sourceMappingURL=MetadataTemplate.mjs.map
